/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportAggregator;
import com.cognos.pogo.monitoring.jmx.report.MBeanWrapper;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class InteractiveReportMonitorCreator {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(InteractiveReportMonitorCreator.class.getName());

    public void createMBeans() {
        MBeanServer server = PogoMBeanServer.getInstance().getServer();
        InteractiveReportAggregator aggregator = new InteractiveReportAggregator();
        Set<ObjectName> objectNameList = this.getObjectNameList(server);
        for (ObjectName name : objectNameList) {
            String service = name.getKeyProperty("service");
            if (service == null) continue;
            if (cat.isDebugEnabled()) {
                cat.debug("Found objectName = " + name + " service = " + service);
            }
            MBeanWrapper typeMBean = new MBeanWrapper(server, name);
            aggregator.addMBean(service, typeMBean);
        }
        try {
            String objectName = MBeanUtils.buildObjectName("type=ReportServerInteractiveRequests");
            cat.debug("Registering " + objectName);
            server.registerMBean(aggregator, MBeanUtils.createObjectNameInstance(objectName));
        }
        catch (JMException e) {
            cat.info("Error registering aggregateInteractiveReportMonitor", (Throwable)e);
        }
    }

    private Set<ObjectName> getObjectNameList(MBeanServer server) {
        try {
            return server.queryNames(MBeanUtils.createObjectNameInstance("type=interactveReportMonitor,*"), null);
        }
        catch (MalformedObjectNameException e) {
            cat.info("Unexpected exception ", (Throwable)e);
            return new HashSet<ObjectName>();
        }
    }
}

