/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanWrapper
implements DynamicMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanWrapper.class.getName());
    private final MBeanServer server;
    private final ObjectName objectName;

    public MBeanWrapper(MBeanServer server, ObjectName objectName) {
        this.server = server;
        this.objectName = objectName;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.server.getAttribute(this.objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            cat.info("Cannot get attribute for " + this.objectName + ", attribute " + attribute, (Throwable)e);
            return null;
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.server.getAttributes(this.objectName, attributes);
        }
        catch (JMException e) {
            cat.info("Cannot get attributes for " + this.objectName, (Throwable)e);
            return null;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this.server.getMBeanInfo(this.objectName);
        }
        catch (JMException e) {
            cat.info("Cannot get MBeanInfo for " + this.objectName, (Throwable)e);
            return null;
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.server.invoke(this.objectName, actionName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            cat.info("Cannot invoke on " + this.objectName, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.server.setAttribute(this.objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            cat.info("Cannot set attribute for " + this.objectName + ", attribute " + attribute, (Throwable)e);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.server.setAttributes(this.objectName, attributes);
        }
        catch (JMException e) {
            cat.info("Cannot set attributes for " + this.objectName, (Throwable)e);
            return null;
        }
    }
}

