/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import java.text.DecimalFormat;

public class LongThresholdComparable
extends ThresholdComparable {
    private final Long value;
    private static final DecimalFormat FORMAT = new DecimalFormat("0");

    public LongThresholdComparable(Long longValue) {
        this.value = longValue;
    }

    public String toString() {
        String formatted = FORMAT.format(this.value);
        return formatted;
    }

    @Override
    public boolean withinHysteresisRange(ThresholdComparable oldValue) {
        if (!(oldValue instanceof LongThresholdComparable)) {
            return false;
        }
        long old = ((LongThresholdComparable)oldValue).value;
        long lvalue = this.value;
        long hRange = (long)((double)lvalue * hysteresisRange);
        long high = lvalue + hRange;
        long low = lvalue - hRange;
        return low <= old && old <= high;
    }

    @Override
    public int compareTo(ThresholdComparable otherValue) {
        Comparable<?> comparable = otherValue.getValue();
        if (comparable instanceof Long) {
            return this.value.compareTo((Long)comparable);
        }
        if (comparable instanceof Double) {
            return this.compareValue((Double)comparable);
        }
        return 0;
    }

    @Override
    public Comparable<?> getValue() {
        return this.value;
    }

    public int compareValue(Double other) {
        long anotherVal;
        long thisVal = this.value;
        return thisVal < (anotherVal = other.longValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }
}

