/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.threshold.SingleAttributeMBean;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServiceHealthAddIn
extends SingleAttributeMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServiceHealthAddIn.class.getName());
    protected static final String HEALTH = "Health";
    private final MBeanServer server;
    private final ObjectName parentObjectName;

    public ServiceHealthAddIn(MBeanServer server, ObjectName parentObjectName) {
        this.server = server;
        this.parentObjectName = parentObjectName;
    }

    public Object getHealth() {
        try {
            return this.server.getAttribute(this.parentObjectName, HEALTH);
        }
        catch (JMException e) {
            cat.error("Problem getting Parent health:", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.equals(HEALTH)) {
            return this.getHealth();
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[]{new MBeanAttributeInfo(HEALTH, "java.lang.String", HEALTH, true, false, false)};
        return attrInfo;
    }
}

