/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.threshold.DoubleThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.LongThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.StringThresholdComparable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class ThresholdComparable {
    protected static double hysteresisRange = 0.025;

    public static ThresholdComparable createThresholdComparable(String stringValue) {
        try {
            Number number = ThresholdComparable.getEnglishNumberFormat().parse(stringValue);
            return ThresholdComparable.create(number);
        }
        catch (ParseException parseException) {
            return new StringThresholdComparable(stringValue);
        }
    }

    protected static NumberFormat getEnglishNumberFormat() {
        return NumberFormat.getInstance(Locale.ENGLISH);
    }

    private static ThresholdComparable create(Object number) {
        if (number instanceof Double) {
            return new DoubleThresholdComparable((Double)number);
        }
        if (number instanceof Long) {
            return new LongThresholdComparable((Long)number);
        }
        if (number instanceof String) {
            return new StringThresholdComparable((String)number);
        }
        return null;
    }

    public abstract boolean withinHysteresisRange(ThresholdComparable var1);

    public abstract int compareTo(ThresholdComparable var1);

    public static ThresholdComparable createThresholdComparable(Comparable<?> number) {
        return ThresholdComparable.create(number);
    }

    public abstract Comparable<?> getValue();

    public boolean equals(Object obj) {
        if (obj instanceof ThresholdComparable) {
            ThresholdComparable other = (ThresholdComparable)obj;
            return other.getValue().equals(this.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    static {
        String hysteresisStr = PropertyInserter.getProperty("thresholdHysteresis");
        if (hysteresisStr != null) {
            try {
                hysteresisRange = Double.parseDouble(hysteresisStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

