/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdHealth;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InvalidAttributeValueException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.QName;

public class ThresholdParameters {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ThresholdParameters.class.getName());
    final ThresholdComparable higherSidePoor;
    final boolean higherSidePoorExclusiveFlag;
    final ThresholdComparable higherSideAverage;
    final boolean higherSideAverageExclusiveFlag;
    final ThresholdComparable lowerSideAverage;
    final boolean lowerSideAverageExclusiveFlag;
    final ThresholdComparable lowerSidePoor;
    final boolean lowerSidePoorExclusiveFlag;
    static final String HIGHER_SIDE_POOR = "higherSidePoor";
    static final String HIGHER_SIDE_POOR_EXCLUSIVE_FLAG = "higherSidePoorExclusiveFlag";
    static final String HIGHER_SIDE_AVERAGE = "higherSideAverage";
    static final String HIGHER_SIDE_AVERAGE_EXCLUSIVE_FLAG = "higherSideAverageExclusiveFlag";
    static final String LOWER_SIDE_AVERAGE = "lowerSideAverage";
    static final String LOWER_SIDE_AVERAGE_EXCLUSIVE_FLAG = "lowerSideAverageExclusiveFlag";
    static final String LOWER_SIDE_POOR = "lowerSidePoor";
    static final String LOWER_SIDE_POOR_EXCLUSIVE_FLAG = "lowerSidePoorExclusiveFlag";
    private static final String LOWER_SIDE_AVERAGE_THRESHOLD = "lowerSideAverageThreshold";
    private static final String LOWER_SIDE_AVERAGE_THRESHOLD_EXCLUSIVE = "lowerSideAverageThresholdExclusive";
    private static final String LOWER_SIDE_POOR_THRESHOLD = "lowerSidePoorThreshold";
    private static final String LOWER_SIDE_POOR_THRESHOLD_EXCLUSIVE = "lowerSidePoorThresholdExclusive";
    private static final String UPPER_SIDE_AVERAGE_THRESHOLD = "upperSideAverageThreshold";
    private static final String UPPER_SIDE_AVERAGE_THRESHOLD_EXCLUSIVE = "upperSideAverageThresholdExclusive";
    private static final String UPPER_SIDE_POOR_THRESHOLD = "upperSidePoorThreshold";
    private static final String UPPER_SIDE_POOR_THRESHOLD_EXCLUSIVE = "upperSidePoorThresholdExclusive";
    private static final String SYSTEM_METRIC_THRESHOLDS_PROPERTY_ENUM = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#";
    private static final String ENUM_LOWERSIDEAVERAGE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#lowerSideAverageThreshold";
    private static final String ENUM_LOWERSIDEAVERAGEEXCLUSIVE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#lowerSideAverageThresholdExclusive";
    private static final String ENUM_LOWERSIDEPOOR = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#lowerSidePoorThreshold";
    private static final String ENUM_LOWERSIDEPOOREXCLUSIVE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#lowerSidePoorThresholdExclusive";
    private static final String ENUM_HIGHERSIDEAVERAGE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#upperSideAverageThreshold";
    private static final String ENUM_HIGHERSIDEAVERAGEEXCLUSIVE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#upperSideAverageThresholdExclusive";
    private static final String ENUM_HIGHERSIDEPOOR = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#upperSidePoorThreshold";
    private static final String ENUM_HIGHERSIDEPOOREXCLUSIVE = "http://developer.cognos.com/ceba/constants/systemMetricThresholdsPropertyEnum#upperSidePoorThresholdExclusive";
    private static final String PROPERTIES = "properties";
    private static final String ITEM = "item";
    private static final String URI = "uri";
    private static final String VALUE = "value";
    private static final QName BUS_SYSTEMMETRICTHRESHOLDS = new QName("systemMetricThresholds", BIBusCommand.BUS_NAMESPACE);
    private static final String SYSTEM_METRIC_ENUM = "http://developer.cognos.com/ceba/constants/systemMetricEnum#";
    protected static String[] typeNames = new String[]{"higherSidePoor", "higherSidePoorExclusiveFlag", "higherSideAverage", "higherSideAverageExclusiveFlag", "lowerSideAverage", "lowerSideAverageExclusiveFlag", "lowerSidePoor", "lowerSidePoorExclusiveFlag"};
    private static String[] typeDescs = new String[]{"higherSidePoor", "higherSidePoorExclusiveFlag", "higherSideAverage", "higherSideAverageExclusiveFlag", "lowerSideAverage", "lowerSideAverageExclusiveFlag", "lowerSidePoor", "lowerSidePoorExclusiveFlag"};
    private static OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.BOOLEAN};
    private CompositeDataSupport compositeData;
    private boolean badCompositeData = false;
    private HashMap<String, Object> mapping;
    private ThresholdComparable crossedThreshold;
    private static CompositeType type;

    public ThresholdParameters(String higherSidePoor, boolean higherSidePoorExclusiveFlag, String higherSideAverage, boolean higherSideAverageExclusiveFlag, String lowerSideAverage, boolean lowerSideAverageExclusiveFlag, String lowerSidePoor, boolean lowerSidePoorExclusiveFlag) throws InvalidAttributeValueException {
        this.higherSidePoor = this.convertToComparable(higherSidePoor);
        this.higherSidePoorExclusiveFlag = higherSidePoorExclusiveFlag;
        this.higherSideAverage = this.convertToComparable(higherSideAverage);
        this.higherSideAverageExclusiveFlag = higherSideAverageExclusiveFlag;
        this.lowerSideAverage = this.convertToComparable(lowerSideAverage);
        this.lowerSideAverageExclusiveFlag = lowerSideAverageExclusiveFlag;
        this.lowerSidePoor = this.convertToComparable(lowerSidePoor);
        this.lowerSidePoorExclusiveFlag = lowerSidePoorExclusiveFlag;
        this.verifyParameters();
    }

    public ThresholdParameters(HashMap<String, String> parameterMap) throws InvalidAttributeValueException {
        this.higherSidePoor = this.getComparableParameter(parameterMap, ENUM_HIGHERSIDEPOOR);
        this.higherSidePoorExclusiveFlag = this.getBooleanParameter(parameterMap, ENUM_HIGHERSIDEPOOREXCLUSIVE);
        this.higherSideAverage = this.convertToComparable(parameterMap.get(ENUM_HIGHERSIDEAVERAGE));
        this.higherSideAverageExclusiveFlag = this.getBooleanParameter(parameterMap, ENUM_HIGHERSIDEAVERAGEEXCLUSIVE);
        this.lowerSideAverage = this.convertToComparable(parameterMap.get(ENUM_LOWERSIDEAVERAGE));
        this.lowerSideAverageExclusiveFlag = this.getBooleanParameter(parameterMap, ENUM_LOWERSIDEAVERAGEEXCLUSIVE);
        this.lowerSidePoor = this.convertToComparable(parameterMap.get(ENUM_LOWERSIDEPOOR));
        this.lowerSidePoorExclusiveFlag = this.getBooleanParameter(parameterMap, ENUM_LOWERSIDEPOOREXCLUSIVE);
        this.verifyParameters();
    }

    private ThresholdComparable getComparableParameter(HashMap<String, String> parameterMap, String parameter) throws InvalidAttributeValueException {
        String parameterValue = parameterMap.get(parameter);
        if (parameterValue == null) {
            throw new InvalidAttributeValueException("Missing parameter: " + parameter);
        }
        return this.convertToComparable(parameterValue);
    }

    private boolean getBooleanParameter(HashMap<String, String> parameterMap, String parameter) throws InvalidAttributeValueException {
        String parameterValue = parameterMap.get(parameter);
        if (parameterValue == null) {
            throw new InvalidAttributeValueException("Missing parameter: " + parameter);
        }
        return Boolean.valueOf(parameterValue);
    }

    private void verifyParameters() throws InvalidAttributeValueException {
        ThresholdComparable checked = null;
        ThresholdComparable[] list = new ThresholdComparable[]{this.higherSidePoor, this.higherSideAverage, this.lowerSideAverage, this.lowerSidePoor};
        for (int i = 0; i < list.length; ++i) {
            ThresholdComparable next = list[i];
            if (checked == null) {
                checked = next;
                continue;
            }
            if (next == null) continue;
            if (checked.compareTo(next) < 0) {
                throw new InvalidAttributeValueException("Parameters are out of order");
            }
            checked = next;
        }
    }

    public CompositeData getCompositeData() {
        if (this.badCompositeData) {
            return null;
        }
        if (this.compositeData == null) {
            try {
                this.compositeData = new CompositeDataSupport(type, this.getMapping());
            }
            catch (OpenDataException e) {
                this.badCompositeData = true;
                return null;
            }
        }
        return this.compositeData;
    }

    public synchronized Map<String, Object> getMapping() {
        if (this.mapping == null) {
            this.mapping = new HashMap();
            this.mapping.put(HIGHER_SIDE_POOR, this.getString(this.higherSidePoor));
            this.mapping.put(HIGHER_SIDE_POOR_EXCLUSIVE_FLAG, this.higherSidePoorExclusiveFlag);
            this.mapping.put(HIGHER_SIDE_AVERAGE, this.getString(this.higherSideAverage));
            this.mapping.put(HIGHER_SIDE_AVERAGE_EXCLUSIVE_FLAG, this.higherSideAverageExclusiveFlag);
            this.mapping.put(LOWER_SIDE_AVERAGE, this.getString(this.lowerSideAverage));
            this.mapping.put(LOWER_SIDE_AVERAGE_EXCLUSIVE_FLAG, this.lowerSideAverageExclusiveFlag);
            this.mapping.put(LOWER_SIDE_POOR, this.getString(this.lowerSidePoor));
            this.mapping.put(LOWER_SIDE_POOR_EXCLUSIVE_FLAG, this.lowerSidePoorExclusiveFlag);
        }
        return this.mapping;
    }

    private String getString(ThresholdComparable value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected ThresholdComparable convertToComparable(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        return ThresholdComparable.createThresholdComparable(value);
    }

    public ThresholdHealth check(ThresholdComparable newValue) {
        int average;
        int poor;
        if (this.higherSidePoor != null && ((poor = newValue.compareTo(this.higherSidePoor)) > 0 || poor == 0 && !this.higherSidePoorExclusiveFlag)) {
            this.crossedThreshold = this.higherSidePoor;
            return ThresholdHealth.POOR;
        }
        if (this.lowerSidePoor != null && ((poor = newValue.compareTo(this.lowerSidePoor)) < 0 || poor == 0 && !this.lowerSidePoorExclusiveFlag)) {
            this.crossedThreshold = this.lowerSidePoor;
            return ThresholdHealth.POOR;
        }
        if (this.higherSideAverage != null && ((average = newValue.compareTo(this.higherSideAverage)) > 0 || average == 0 && !this.higherSideAverageExclusiveFlag)) {
            this.crossedThreshold = this.higherSideAverage;
            return ThresholdHealth.AVERAGE;
        }
        if (this.lowerSideAverage != null && ((average = newValue.compareTo(this.lowerSideAverage)) < 0 || average == 0 && !this.lowerSideAverageExclusiveFlag)) {
            this.crossedThreshold = this.lowerSideAverage;
            return ThresholdHealth.AVERAGE;
        }
        return ThresholdHealth.GOOD;
    }

    public ThresholdComparable getCrossedThreshold() {
        return this.crossedThreshold;
    }

    public void addSystemMetricThresholds(Element element, String metricName) {
        Element metricElement = element.addElement(BUS_SYSTEMMETRICTHRESHOLDS);
        metricElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":systemMetricThresholds");
        this.addSystemMetricProperties(metricElement, metricName);
    }

    public void addSystemMetricProperties(Element metricElement, String metricName) {
        this.addSystemMetricProperties(metricElement);
        Element systemMetricElement = metricElement.addElement("systemMetric");
        systemMetricElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":anyURIProp");
        Element valueElement = systemMetricElement.addElement(VALUE);
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        valueElement.setText(SYSTEM_METRIC_ENUM + metricName);
    }

    public void addSystemMetricProperties(Element systemMetricThresholdsElement) {
        Element propertiesElement = systemMetricThresholdsElement.addElement(PROPERTIES);
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":uriValueArrayProp");
        Element valueArrayElement = propertiesElement.addElement(VALUE);
        valueArrayElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        valueArrayElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":uriValue[]");
        this.addThresholdToElement(valueArrayElement, ENUM_LOWERSIDEAVERAGE, ENUM_LOWERSIDEAVERAGEEXCLUSIVE, this.lowerSideAverage, this.lowerSideAverageExclusiveFlag);
        this.addThresholdToElement(valueArrayElement, ENUM_LOWERSIDEPOOR, ENUM_LOWERSIDEPOOREXCLUSIVE, this.lowerSidePoor, this.lowerSidePoorExclusiveFlag);
        this.addThresholdToElement(valueArrayElement, ENUM_HIGHERSIDEAVERAGE, ENUM_HIGHERSIDEAVERAGEEXCLUSIVE, this.higherSideAverage, this.higherSideAverageExclusiveFlag);
        this.addThresholdToElement(valueArrayElement, ENUM_HIGHERSIDEPOOR, ENUM_HIGHERSIDEPOOREXCLUSIVE, this.higherSidePoor, this.higherSidePoorExclusiveFlag);
    }

    private void addThresholdToElement(Element valueArrayElement, String thresholdName, String thresholdFlagName, ThresholdComparable value, boolean exclusiveFlag) {
        String valueStr = "";
        if (value != null) {
            valueStr = value.toString();
        }
        this.addUriValue(valueArrayElement, thresholdName, valueStr);
        this.addUriValue(valueArrayElement, thresholdFlagName, Boolean.toString(exclusiveFlag));
    }

    private void addUriValue(Element valueArrayElement, String name, String value) {
        Element itemElement = valueArrayElement.addElement(ITEM);
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":uriValue");
        Element uriElement = itemElement.addElement(URI);
        uriElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        uriElement.setText(name);
        Element valueElement = itemElement.addElement(VALUE);
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        valueElement.setText(value);
    }

    public static void addThresholdsToQuery(ContentManagerQueryCommand query) {
        query.addQueryPropertyName(PROPERTIES);
    }

    public static ThresholdParameters create(Element fromElement) throws InvalidAttributeValueException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Element propertiesElement = fromElement.element(PROPERTIES);
        Element valueElement = propertiesElement.element(VALUE);
        List itemList = valueElement.elements();
        for (Element itemElement : itemList) {
            ThresholdParameters.addUriValue(parameterMap, itemElement);
        }
        return new ThresholdParameters(parameterMap);
    }

    private static void addUriValue(HashMap<String, String> parameterMap, Element itemElement) {
        String uri = itemElement.element(URI).getTextTrim();
        String value = itemElement.element(VALUE).getTextTrim();
        parameterMap.put(uri, value);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Parameters: ");
        buf.append(" hsp= ").append(this.higherSidePoor);
        buf.append(" hspe= ").append(this.higherSidePoorExclusiveFlag);
        buf.append(" hsa= ").append(this.higherSideAverage);
        buf.append(" hsae= ").append(this.higherSideAverageExclusiveFlag);
        buf.append(" lsa= ").append(this.lowerSideAverage);
        buf.append(" lsae= ").append(this.lowerSideAverageExclusiveFlag);
        buf.append(" lsp= ").append(this.lowerSidePoor);
        buf.append(" lspe= ").append(this.lowerSidePoorExclusiveFlag);
        return buf.toString();
    }

    public static CompositeType getType() {
        return type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThresholdParameters) {
            ThresholdParameters other = (ThresholdParameters)obj;
            return this.equalsOrNull(this.higherSidePoor, other.higherSidePoor) && this.higherSidePoorExclusiveFlag == other.higherSidePoorExclusiveFlag && this.equalsOrNull(this.higherSideAverage, other.higherSideAverage) && this.higherSideAverageExclusiveFlag == other.higherSideAverageExclusiveFlag && this.equalsOrNull(this.lowerSideAverage, other.lowerSideAverage) && this.lowerSideAverageExclusiveFlag == other.lowerSideAverageExclusiveFlag && this.equalsOrNull(this.lowerSidePoor, other.lowerSidePoor) && this.lowerSidePoorExclusiveFlag == other.lowerSidePoorExclusiveFlag;
        }
        return false;
    }

    private boolean equalsOrNull(ThresholdComparable parameter1, ThresholdComparable parameter2) {
        if (parameter1 == null && parameter2 == null) {
            return true;
        }
        return parameter1 != null && parameter2 != null && parameter1.equals(parameter2);
    }

    public int hashCode() {
        return super.hashCode();
    }

    String getHigherSidePoor() {
        return this.higherSidePoor.toString();
    }

    boolean isHigherSidePoorExclusiveFlag() {
        return this.higherSidePoorExclusiveFlag;
    }

    String getHigherSideAverage() {
        return this.higherSideAverage.toString();
    }

    boolean isHigherSideAverageExclusiveFlag() {
        return this.higherSideAverageExclusiveFlag;
    }

    String getLowerSideAverage() {
        return this.lowerSideAverage.toString();
    }

    boolean isLowerSideAverageExclusiveFlag() {
        return this.lowerSideAverageExclusiveFlag;
    }

    String getLowerSidePoor() {
        return this.lowerSidePoor.toString();
    }

    boolean isLowerSidePoorExclusiveFlag() {
        return this.lowerSidePoorExclusiveFlag;
    }

    static {
        try {
            type = new CompositeType("Thresholds", "thresholds", typeNames, typeDescs, typeTypes);
        }
        catch (OpenDataException e) {
            cat.error("catch", (Throwable)e);
        }
    }
}

