/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanUtils {
    static final String DOMAIN_SEPARATTOR = ":";
    private static final String WEBAPP_NAME = "/hessian";
    private static final String PROXY_WEBAPP_NAME = "/hessianproxy";

    public static ObjectName getHealthObjectName(ObjectName mBeanObjectName) throws MalformedObjectNameException {
        Hashtable<String, String> keyPropertyList = mBeanObjectName.getKeyPropertyList();
        keyPropertyList.put("type", "MetricHealth");
        ObjectName healthObjectName = new ObjectName(mBeanObjectName.getDomain(), keyPropertyList);
        return healthObjectName;
    }

    public static ObjectName addDispatcherName(ObjectName objectName, String dispatcherName) throws MalformedObjectNameException {
        return MBeanUtils.addKey(objectName, "dispatcher", dispatcherName);
    }

    public static ObjectName addKey(ObjectName objectName, String key, String value) throws MalformedObjectNameException {
        Hashtable<String, String> hash = objectName.getKeyPropertyList();
        hash.put(key, ObjectName.quote(value));
        ObjectName proxyName = new ObjectName(objectName.getDomain(), hash);
        return proxyName;
    }

    public static ObjectName removeKey(ObjectName objectName, String key) throws MalformedObjectNameException {
        Hashtable<String, String> hash = objectName.getKeyPropertyList();
        hash.remove(key);
        ObjectName proxyName = new ObjectName(objectName.getDomain(), hash);
        return proxyName;
    }

    public static ObjectName addDispatcherName(ObjectName objectName, JMXDispatcher dispatcher) throws MalformedObjectNameException {
        return MBeanUtils.addDispatcherName(objectName, ObjectName.quote(dispatcher.getName()));
    }

    public static ObjectName getObjectName(String serviceName, String metricName, String dispatcher) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":type=" + metricName + ",service=" + serviceName + ",dispatcher=" + ObjectName.quote(dispatcher));
    }

    public static ObjectName getObjectName(String serviceName, String metricName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":type=" + metricName + ",service=" + serviceName);
    }

    public static ObjectName getObjectName(String serviceName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":service=" + serviceName);
    }

    public static ObjectName getDispatcherPattern(String dispatcher, String metricName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":type=" + metricName + ",dispatcher=" + ObjectName.quote(dispatcher) + ",*");
    }

    public static ObjectName getDispatcherObjectName(String dispatcher, String metricName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":type=" + metricName + ",dispatcher=" + ObjectName.quote(dispatcher));
    }

    public static ObjectName getAllServicesPattern(String metricName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":type=" + metricName + ",*");
    }

    public static final String replaceJmxDomainWithCurrent(String name) {
        return PogoMBeanServer.getJmxDomain() + name.substring(name.indexOf(DOMAIN_SEPARATTOR));
    }

    public static final boolean isSystemJmxDomain(String domain) {
        return domain.startsWith("java.");
    }

    public static ObjectName getServicePattern(String serviceName) throws MalformedObjectNameException {
        return new ObjectName(PogoMBeanServer.getJmxDomain() + ":service=" + serviceName + ",*");
    }

    public static final String buildObjectName(String keyProperties) {
        String objectName = null;
        String prefix = PogoMBeanServer.getJmxDomain() + DOMAIN_SEPARATTOR;
        objectName = keyProperties.startsWith(prefix) ? keyProperties : prefix + keyProperties;
        return objectName;
    }

    public static final ObjectName createObjectNameInstance(String keyProperties) throws MalformedObjectNameException {
        return ObjectName.getInstance(MBeanUtils.buildObjectName(keyProperties));
    }

    public static String getHessianJmxUrl(boolean sslEnabled, String hostPortContext) {
        return MBeanUtils.getJmxUrl(sslEnabled, hostPortContext, WEBAPP_NAME);
    }

    public static String getProxyHessianJmxUrl(boolean sslEnabled, String hostPortContext) {
        return MBeanUtils.getJmxUrl(sslEnabled, hostPortContext, PROXY_WEBAPP_NAME);
    }

    public static String getJmxUrl(boolean sslEnabled, String hostPortContext, String webapp) {
        StringBuffer urlBuf = new StringBuffer();
        if (sslEnabled) {
            urlBuf.append("service:jmx:hessian+ssl://");
        } else {
            urlBuf.append("service:jmx:hessian://");
        }
        urlBuf.append(hostPortContext);
        urlBuf.append(webapp);
        return urlBuf.toString();
    }

    public static String getHostFromUrl(String hessianUrl) {
        String[] split = MBeanUtils.splitHessianUrl(hessianUrl);
        return split[1];
    }

    private static String[] splitHessianUrl(String hessianUrl) {
        String[] split = hessianUrl.split("//");
        String[] split2 = split[1].split(WEBAPP_NAME);
        return new String[]{split[0], split2[0]};
    }

    public static String getHostUrlFromHessianUrl(String hessianUrl) {
        String[] split = MBeanUtils.splitHessianUrl(hessianUrl);
        return (split[0].endsWith("ssl:") ? "https://" : "http://") + split[1];
    }

    public static int getLocalProcessId() {
        String beanName = MBeanUtils.getRuntimeMXBeanName();
        return Integer.parseInt(beanName.substring(0, beanName.indexOf("@")));
    }

    protected static String getRuntimeMXBeanName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

