/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.monitoring.jmx.SingleUserPasswordAuthenticator;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoRmiAuthenticationConfiguration;
import com.cognos.pogo.monitoring.jmx.utils.PogoRmiRegistry;
import com.cognos.pogo.monitoring.jmx.utils.PortProperty;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.management.MBeanServer;

public abstract class PogoMBeanRMIServerConnection
extends PogoMBeanServerConnection {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final String USE_CODEBASE_ONLY = "java.rmi.server.useCodebaseOnly";
    private static final String SERVICEURL_0 = "service:jmx:rmi://";
    private static final String SERVICEURL_1 = "/jndi/rmi://";
    private static final String JMXSERVERPORT_PROPERTY = "jmxServerPort";
    private PogoRmiRegistry pogoRmiRegistry;
    private String[] credentials;

    public PogoMBeanRMIServerConnection(MBeanServer server, PogoRmiRegistry pogoRmiRegistry) {
        super(server);
        this.pogoRmiRegistry = pogoRmiRegistry;
        this.setupAuthentication();
    }

    protected void setupAuthentication() {
        ICCLConfiguration configuration = this.getConfiguration();
        PogoRmiAuthenticationConfiguration authenticationConfiguration = new PogoRmiAuthenticationConfiguration(configuration);
        int rmiPort = authenticationConfiguration.getPort();
        this.credentials = authenticationConfiguration.getCredentials();
        int rmiServerPort = PortProperty.getPortFromProperty(JMXSERVERPORT_PROPERTY);
        this.pogoRmiRegistry.setPort(rmiPort);
        this.pogoRmiRegistry.setServerPort(rmiServerPort);
    }

    protected ICCLConfiguration getConfiguration() {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        return configuration;
    }

    @Override
    protected String getConnectionString() {
        return this.getBaseConnectionString() + this.getConnectionExtension();
    }

    protected abstract String getConnectionExtension();

    private String getBaseConnectionString() {
        String rmiServerHost;
        StringBuffer jmxrmi = new StringBuffer(SERVICEURL_0);
        try {
            rmiServerHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            rmiServerHost = "localhost";
        }
        if (this.pogoRmiRegistry.getServerPort() != -1) {
            jmxrmi.append(rmiServerHost).append(":").append(this.pogoRmiRegistry.getServerPort());
        }
        jmxrmi.append(SERVICEURL_1).append(rmiServerHost).append(":").append(this.pogoRmiRegistry.getRegistryPort());
        if (log.isDebugEnabled()) {
            log.debug(jmxrmi.toString());
        }
        return jmxrmi.toString();
    }

    @Override
    public void start() throws IOException {
        this.startRMIConnectorIfEnabled();
    }

    private void startRMIConnectorIfEnabled() {
        if (this.pogoRmiRegistry.isEnabled()) {
            try {
                this.startRMIConnector();
            }
            catch (Exception e) {
                log.info("Unable to start RMI registry", e);
            }
        }
    }

    private void startRMIConnector() throws MalformedURLException, IOException {
        this.pogoRmiRegistry.checkRMIRegistryAndStart();
        if (this.handleSpaceInClassLoaderResource()) {
            this.startConnectionUseCodebaseOnly();
        } else {
            this.startConnector();
        }
    }

    private boolean handleSpaceInClassLoaderResource() {
        String replacedPeriods = this.getClass().getName().replaceAll("\\.", "/");
        URL resource = this.getClass().getClassLoader().getResource(replacedPeriods);
        if (resource == null) {
            return false;
        }
        return resource.getPath().indexOf(32) > -1;
    }

    private synchronized void startConnectionUseCodebaseOnly() throws IOException {
        String current = this.setUseCodeBaseOnlyProperty();
        this.startConnector();
        this.resetUseCodebaseOnlyProperty(current);
    }

    private String setUseCodeBaseOnlyProperty() {
        String current = System.getProperty(USE_CODEBASE_ONLY);
        System.setProperty(USE_CODEBASE_ONLY, "true");
        return current;
    }

    private void resetUseCodebaseOnlyProperty(String current) {
        System.setProperty(USE_CODEBASE_ONLY, current);
    }

    @Override
    protected void startConnector() throws MalformedURLException, IOException {
        this.createAuthenticator();
        super.startConnector();
    }

    private void createAuthenticator() {
        if (this.credentials != null) {
            SingleUserPasswordAuthenticator authenticator = new SingleUserPasswordAuthenticator(this.credentials);
            this.environment.put("jmx.remote.authenticator", authenticator);
        }
    }
}

