/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.handler;

import com.cognos.pogo.handlers.logic.NoopHandler;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiServiceHandler
extends BasicHandler
implements ServiceTrackerCustomizer {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String osgiService;
    private Handler osgiHandler;
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;
    private Configuration configuration;
    private Handler previousOsgiHandler;

    public OsgiServiceHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.osgiService = this.getAttribute(log, "osgiservice");
    }

    Handler getHandler() {
        if (this.osgiHandler == null) {
            log.error("Handler for ", this.osgiService, " has not been registerd.  Substituting NoopHandler");
            this.osgiHandler = new NoopHandler();
        }
        return this.osgiHandler;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.lookupOsgiHandler(engine);
        this.contextualizeAndCompose(engine);
    }

    private void contextualizeAndCompose(PogoEngine engine) throws PogoException {
        this.getHandler().contextualize(this.getConfig());
        this.getHandler().compose(engine);
    }

    private void lookupOsgiHandler(PogoEngine engine) {
        this.bundleContext = this.getBundleContext(engine);
        this.serviceTracker = new ServiceTracker(this.bundleContext, this.osgiService, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    protected BundleContext getBundleContext(PogoEngine engine) {
        return (BundleContext)engine.getContextAttribute("com.ibm.cognos.pogo.bundle.context");
    }

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
        this.getHandler().configure(configuration);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configuration = configuration;
        this.getHandler().reconfigure(configuration);
    }

    @Override
    public void initialize() {
        this.getHandler().initialize();
    }

    @Override
    public void start() {
        this.getHandler().start();
    }

    @Override
    public void allServicesStarted() {
        this.getHandler().allServicesStarted();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        log.debug("Invoking ", this.osgiService, " with ", this.osgiHandler);
        this.getHandler().invoke(mc);
    }

    @Override
    public void suspend(boolean immediate) {
        this.getHandler().suspend(immediate);
    }

    @Override
    public void resume() {
        this.getHandler().resume();
    }

    @Override
    public void stop() {
        this.getHandler().stop();
    }

    @Override
    public void dispose() {
        this.getHandler().dispose();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object addingService(ServiceReference reference) {
        this.osgiHandler = (Handler)this.bundleContext.getService(reference);
        log.debug("Added handler reference: ", this.osgiHandler);
        this.maybeTryToRestart(this.previousOsgiHandler);
        return this.osgiHandler;
    }

    private void maybeTryToRestart(Handler oldHandler) {
        if (this.handlerIsValid(oldHandler)) {
            this.tryToRestart();
        }
    }

    boolean handlerIsValid(Handler oldHandler) {
        return oldHandler != null && !(oldHandler instanceof NoopHandler);
    }

    private void tryToRestart() {
        try {
            log.debug("Restarting handler for ", this.osgiService);
            this.restart();
        }
        catch (PogoException e) {
            log.error("Pogo exception trying to restart " + this.osgiService, e);
        }
    }

    protected void restart() throws PogoException {
        this.contextualizeAndCompose(this.getPogoEngine());
        this.configure(this.configuration);
        this.initialize();
        this.start();
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.getHandler().stop();
        log.debug("Removed handler reference: ", service);
        this.previousOsgiHandler = this.osgiHandler;
        this.osgiHandler = null;
    }
}

