/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.contentmanager.cache.CMCacheService;
import com.cognos.pogo.contentmanager.cache.CMCacheServiceListener;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.util.PogoLogger;
import org.apache.log.Logger;
import org.dom4j.Element;

public abstract class BasicHandler
implements Handler,
CMCacheServiceListener {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final boolean defaultSkipOnFault = true;
    private static final boolean defaultIsCmCacheMonitor = false;
    protected boolean prepared;
    protected Element e_config;
    protected String name;
    private PogoEngine _bhPogoEngine;
    protected boolean skipOnFault = true;
    protected boolean isCmCacheMonitor = false;
    private SimpleRequestReportingHandler reportingHandler;
    private String fullname = null;

    public BasicHandler(Logger subclassLog) {
        if (subclassLog == null) {
            log.info("subclass of BasicHandler ", this.getFullName(), " passed null logger. Using default logger.");
            log.getNativeLogger();
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        this.e_config = config;
    }

    protected Element getConfig() {
        return this.e_config;
    }

    protected boolean testProperty(MessageContext mc, String name) {
        Object o = mc.getProperty(name);
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return ((String)o).equals("true");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    protected String getAttribute(PogoLogger log, String name) throws PogoException {
        return this.getRequiredAttribute(log.getNativeLogger(), name);
    }

    protected String getRequiredAttribute(Logger cat, String name) throws PogoException {
        String at = this.getConfig().attributeValue(name);
        if (at == null || at.length() == 0) {
            cat.error("required attribute \"" + name + "\" is missing on handler " + this.getFullName());
            throw new PogoException("handler requires \"" + name + "\" attribute");
        }
        return at;
    }

    protected String getOptionalAttribute(String name) {
        return this.getConfig().attributeValue(name);
    }

    @Override
    public final void compose(PogoEngine engine) throws PogoException {
        this._bhPogoEngine = engine;
        if (!this.prepared) {
            this.setHandlerAttributes(engine);
            this.compose_impl(engine);
            this.prepared = true;
        }
    }

    private void setHandlerAttributes(PogoEngine engine) {
        this.setSkipOnFault();
        this.setMonitorCmCache();
        this.setReportingHandler(engine);
    }

    private void setSkipOnFault() {
        this.skipOnFault = this.getBooleanAttribute("skip_on_fault", true);
    }

    public boolean getSkipOnFault() {
        return this.skipOnFault;
    }

    private boolean getBooleanAttribute(String attributeName, boolean defaultValue) {
        String attributeValue = this.getConfig().attributeValue(attributeName);
        return attributeValue != null ? Boolean.valueOf(attributeValue) : defaultValue;
    }

    private void setMonitorCmCache() {
        this.isCmCacheMonitor = this.getBooleanAttribute("isCmCacheMonitor", false);
        if (this.isCmCacheMonitor) {
            CMCacheService.registerForNotifications(this);
        }
    }

    @Override
    public void notifyCmCacheStateChange(boolean isEnabled) {
        log.debug("CM Cache Service status changed. Cache is now ", isEnabled ? "enabled." : "disabled.");
    }

    private void setReportingHandler(PogoEngine engine) {
        String handlerName = this.getOptionalAttribute("reportingHandler");
        if (handlerName != null) {
            this.reportingHandler = (SimpleRequestReportingHandler)engine.lookupHandler(handlerName);
        }
    }

    protected boolean skipOnFault(Logger cat, MessageContext mc) {
        if (this.skipOnFault && mc.isFaulted()) {
            cat.debug("faulted, so skipping");
            return true;
        }
        return false;
    }

    public String getFullName() {
        if (this.fullname == null) {
            this.fullname = "[" + this.getName() + "] " + this.getClass().getName();
        }
        return this.fullname;
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
    }

    public abstract void invokeImpl(MessageContext var1) throws PogoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(MessageContext mc) throws PogoException {
        if (this.skipOnFault && mc.isFaulted()) {
            log.debug("skipping ", this.getFullName());
            return;
        }
        mc.pushTB(this);
        try {
            this.getPogoEngine().logTraceRequest(this.getFullName());
            log.debug("invoking ", this.getFullName());
            this.invokeImpl(mc);
        }
        catch (PogoException ex) {
            Fault f = new Fault("BasicHandler.cantService", ex);
            Object[] obj = new Object[]{ex.getLocalizedMessage()};
            f.setMessageParameters(obj);
            mc.setFault(f);
        }
        finally {
            mc.popTB();
        }
    }

    @Override
    public void configure(Configuration configuration) {
    }

    @Override
    public void initialize() {
    }

    @Override
    public void reconfigure(Configuration configuration) {
    }

    @Override
    public void resume() {
    }

    @Override
    public void start() {
    }

    @Override
    public void allServicesStarted() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void suspend(boolean immediate) {
    }

    public void flagNotStartable() throws IllegalStateException {
        if (this.reportingHandler == null) {
            throw new IllegalStateException(DispatcherStrings.getInstance().getString("BasicHandler.noReporter"));
        }
        this.reportingHandler.flagNotStartable();
    }

    protected PogoEngine getPogoEngine() {
        return this._bhPogoEngine;
    }

    public PerformanceEventListener getPerformanceIndicator() {
        return PerformanceIndicator.getListener();
    }

    public String getParentServiceName() {
        Element config = this.getConfig();
        return config != null ? config.getDocument().getRootElement().attributeValue("name") : null;
    }
}

