/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class Dereferencer {
    public Document dereference(Document document) {
        Element envelope = document.getRootElement();
        Element header = envelope.element("Header");
        HashMap<String, IdElement> headerMap = null;
        if (header != null) {
            headerMap = this.getIds(header);
        }
        if (header != null && headerMap.size() > 0) {
            this.fixupElement(header, headerMap);
            Element body = envelope.element("Body");
            HashMap<String, IdElement> bodyMap = this.getIds(body);
            if (bodyMap.size() > 0) {
                this.fixupElement(body, bodyMap);
            }
        } else {
            HashMap<String, IdElement> bodyMap;
            Element body = envelope.element("Body");
            if (body != null && (bodyMap = this.getIds(body)).size() > 0) {
                this.fixupElement(envelope, bodyMap);
            }
        }
        return document;
    }

    private HashMap<String, IdElement> getIds(Element baseElement) {
        HashMap<String, IdElement> idmap = new HashMap<String, IdElement>();
        Iterator iditer = baseElement.elementIterator();
        while (iditer.hasNext()) {
            Element element = (Element)iditer.next();
            String idAttr = element.attributeValue("id");
            if (idAttr == null) continue;
            idmap.put(idAttr, new IdElement(element));
        }
        return idmap;
    }

    private void fixupElement(Element idElement, HashMap<String, IdElement> idMap) {
        String attr = idElement.attributeValue("href");
        if (attr != null) {
            this.deref(idElement, idMap);
        } else {
            List list = idElement.elements();
            for (Element e : list) {
                this.fixupElement(e, idMap);
            }
        }
    }

    private void deref(Element refElement, HashMap<String, IdElement> idMap) {
        String hrefVal = refElement.attributeValue("href");
        if (hrefVal == null) {
            return;
        }
        String hrefName = hrefVal.substring(1);
        IdElement frog = idMap.get(hrefName);
        Element idElement = frog.element;
        if (!frog.fixed) {
            idElement.detach();
            idElement = frog.element.createCopy(refElement.getQName());
            this.fixupElement(idElement, idMap);
            idElement.remove(frog.element.attribute("id"));
            frog.element = idElement;
            frog.fixed = true;
        } else {
            idElement = frog.element.createCopy(refElement.getQName());
        }
        Element parent = refElement.getParent();
        List parentContent = parent.content();
        int childIndex = parentContent.indexOf(refElement);
        parentContent.set(childIndex, idElement);
    }

    private class IdElement {
        Element element;
        boolean fixed = false;

        IdElement(Element element) {
            this.element = element;
        }
    }
}

