/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jBodyFaultDetail;
import org.dom4j.Element;

public class Dom4jBodyFault
extends Dom4jBase
implements BodyFault {
    private final SOAPEnvelope envelope;

    public Dom4jBodyFault(SOAPEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public BodyFaultDetail getDetail() {
        return new Dom4jBodyFaultDetail(this);
    }

    @Override
    public String getFaultActor() {
        return this.getFaultText("faultactor");
    }

    @Override
    public void setFaultActor(String faultActor) {
        this.setFaultText("faultactor", faultActor);
    }

    @Override
    public String getFaultCode() {
        return this.getFaultText("faultcode");
    }

    @Override
    public void setFaultCode(String faultCode) {
        this.setFaultText("faultcode", faultCode);
    }

    @Override
    public String getFaultString() {
        return this.getFaultText("faultstring");
    }

    @Override
    public void setFaultString(String faultString) {
        this.setFaultText("faultstring", faultString);
    }

    private String getFaultText(String itemName) {
        Element fault = this.getFault();
        Element faultItem = fault != null ? fault.element(itemName) : null;
        return faultItem != null ? faultItem.getTextTrim() : null;
    }

    private void setFaultText(String itemName, String value) {
        Element fault = this.getOrCreateFault();
        Element faultItem = fault.element(itemName);
        if (faultItem != null) {
            faultItem.setText(value);
        } else {
            fault.addElement(itemName).addText(value);
        }
    }

    Element getOrCreateFault() {
        Element fault = this.getFault();
        if (fault == null) {
            fault = this.createFault();
        }
        return fault;
    }

    private Element createFault() {
        return this.envelope.getBody().addElement(SOAPEnvelope.SOAP_ENV_FAULT);
    }

    @Override
    public String asXML() {
        Element fault = this.getFault();
        return fault != null ? fault.asXML() : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent();
    }

    @Override
    public boolean isPresent() {
        return this.envelope.getFault() != null;
    }

    Element getFault() {
        return this.envelope.getFault();
    }

    @Override
    public void clear() {
        Element fault = this.getFault();
        if (fault != null) {
            fault.detach();
        }
    }

    @Override
    public void setExceptionFault(SoapFaultException soapFaultException) {
        Element faultElement = this.getFault();
        soapFaultException.setFault(faultElement);
    }
}

