/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.dom4j.Dom4jBodyFault;
import com.cognos.pogo.pdk.dom4j.Dom4jBodyFaultException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class Dom4jBodyFaultDetail
implements BodyFaultDetail {
    private final Dom4jBodyFault bodyFault;

    public Dom4jBodyFaultDetail(Dom4jBodyFault bodyFault) {
        this.bodyFault = bodyFault;
    }

    @Override
    public List<BodyFaultException> getExceptions() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BodyFaultException> exceptions = new ArrayList<BodyFaultException>();
        this.copyExceptionsTo(exceptions);
        return Collections.unmodifiableList(exceptions);
    }

    private void copyExceptionsTo(List<BodyFaultException> exceptions) {
        Element detail = this.getFaultDetail();
        if (detail != null) {
            for (Element exception : detail.elements()) {
                exceptions.add(new Dom4jBodyFaultException(exception));
            }
        }
    }

    Element getFaultDetail() {
        Element fault = this.bodyFault.getFault();
        return fault != null ? fault.element("detail") : null;
    }

    @Override
    public String asXML() {
        return this.getFaultDetail().asXML();
    }

    @Override
    public boolean isEmpty() {
        Element detail = this.getFaultDetail();
        return detail == null || detail.elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        return this.getFaultDetail() != null;
    }

    @Override
    public BodyFaultException createAndAddException() {
        Element detail = this.getOrCreateDetail();
        Element exception = detail.addElement(BIBusEnvelope.BUS_EXCEPTION);
        return new Dom4jBodyFaultException(exception);
    }

    private Element getOrCreateDetail() {
        this.bodyFault.getOrCreateFault();
        Element detail = this.getFaultDetail();
        if (detail == null) {
            detail = this.bodyFault.getFault().addElement("detail");
        }
        return detail;
    }

    @Override
    public void clear() {
        Element detail = this.getFaultDetail();
        if (detail != null) {
            detail.clearContent();
        }
    }
}

