/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jCAMPassport;
import com.cognos.pogo.pdk.dom4j.Dom4jCamException;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.QName;

public class Dom4jCam
extends Dom4jBase
implements Cam {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final BIBusEnvelope envelope;
    private Dom4jCamException exception;
    private Dom4jCAMPassport camPassport;

    public Dom4jCam(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public String asXML() {
        return this.isPresent() ? this.getOptionalCAM().asXML() : null;
    }

    @Override
    public boolean isPresent() {
        return this.getOptionalCAM() != null;
    }

    private Element getOptionalCAM() {
        return this.envelope.getOptionalCAM();
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent();
    }

    @Override
    public String getAction() {
        return this.envelope.getCAMAction();
    }

    @Override
    public void setAction(String action) {
        this.envelope.setCAMaction(action);
    }

    @Override
    public String getUserSessionId() {
        return this.getOptionalElementText("userSessionID");
    }

    @Override
    public void setUserSessionId(String userSessionId) {
        this.setChildElementText(BIBusEnvelope.BUS_CAM_USERSESSIONID, BIBusEnvelope.XSD_BASE64BINARY, userSessionId);
    }

    private void setChildElementText(QName qname, String type, String value) {
        Dom4jCam.setChildElementText(this.envelope.getCAM(), qname.getName(), type, value);
    }

    @Override
    public String getAuthenticityToken() {
        return this.getOptionalElementText("authenticityToken");
    }

    @Override
    public void setAuthenticityToken(String authenticityToken) {
        this.setChildElementText(BIBusEnvelope.BUS_CAM_AUTHENTICITYTOKEN, BIBusEnvelope.XSD_BASE64BINARY, authenticityToken);
    }

    private String getOptionalElementText(String elementName) {
        Element cam = this.getOptionalCAM();
        Element element = cam != null ? cam.element(elementName) : null;
        return element != null ? element.getText() : null;
    }

    @Override
    public void setCamCookie(String camCookieString) {
        CAMCookie camCookie = CAMUtils.createCookie(camCookieString);
        this.setCamCookie(camCookie);
    }

    @Override
    public Dom4jCamException getException() {
        if (this.exception == null) {
            this.exception = new Dom4jCamException(this.envelope);
        }
        return this.exception;
    }

    @Override
    public Dom4jCAMPassport getCAMPassport() {
        if (this.camPassport == null) {
            this.camPassport = new Dom4jCAMPassport(this.envelope);
        }
        return this.camPassport;
    }

    @Override
    public void setCamCookie(CAMCookie camCookie) {
        log.debug("Copying CAM Cookie to BIBus header");
        try {
            Element camElement = camCookie.asXML();
            Dom4jCam.addCamElementToEnvelope(this.envelope, camElement);
        }
        catch (Exception e) {
            log.warn("Error copying CAM Cookie to BIBus header", e);
        }
    }

    private static void addCamElementToEnvelope(BIBusEnvelope envelope, Element newCamElement) {
        Element currentCamElement = envelope.getCAM();
        BIBusEnvelope.stripXSINilAttribute(currentCamElement);
        Iterator it = newCamElement.elementIterator();
        while (it.hasNext()) {
            Dom4jCam.detachAndAdd(currentCamElement, (Element)it.next());
        }
    }

    private static void detachAndAdd(Element camElement, Element camChild) {
        camChild.detach();
        Dom4jCam.removeChildFromElement(camElement, camChild);
        camElement.add(camChild);
    }

    private static void removeChildFromElement(Element camElement, Element camChild) {
        String childName = camChild.getName();
        Element childElement = camElement.element(childName);
        if (childElement != null) {
            camElement.remove(childElement);
        }
    }

    @Override
    public boolean hasIncompleteCamElement() {
        return this.getOptionalCAM() != null && !this.envelope.hasCamSettingsElement();
    }
}

