/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.FormFieldVars;
import com.cognos.pogo.util.NameValuePair;
import java.util.List;
import org.dom4j.Element;

public class Dom4jFormFieldVars
implements FormFieldVars {
    private final BIBusEnvelope envelope;

    public Dom4jFormFieldVars(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public String getValue(String name) {
        return this.envelope.getFormValue(name);
    }

    @Override
    public String getFormat(String name) {
        return this.envelope.getFormFormat(name);
    }

    @Override
    public String asXML() {
        return this.envelope.getFormFieldVars().asXML();
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent() || this.envelope.getFormFieldVars().elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        Element hdrElement = this.envelope.getBIBusHeader().element(BIBusEnvelope.BUS_HDR_SESSION);
        return hdrElement != null && hdrElement.element(BIBusEnvelope.BUS_FORM_FIELD_VARS) != null;
    }

    @Override
    public List<NameValuePair> getNamesAndValues() {
        return this.envelope.getFormFieldValues();
    }

    @Override
    public void setFormField(String name, String value) {
        this.envelope.setFormField(name, value);
    }

    @Override
    public void setFormField(String name, String value, String format) {
        this.envelope.setFormField(name, value, format);
    }

    @Override
    public void addFormField(String name, String value, String format) {
        this.envelope.addFormField(name, value, format);
    }

    @Override
    public void importFormFieldVarsFrom(Envelope source) {
        Element sourceVars = ((BIBusEnvelope)source).getFormFieldVars();
        if (sourceVars != null) {
            sourceVars.detach();
            this.importFormFieldVarsFrom(sourceVars);
        }
    }

    private void importFormFieldVarsFrom(Element sourceVars) {
        Element destinationVars = this.envelope.getFormFieldVars();
        if (destinationVars != null) {
            destinationVars.detach();
        }
        this.envelope.getHdrSession().add(sourceVars);
    }

    @Override
    public void clear() {
        Element element = this.envelope.getFormFieldVars();
        if (element != null) {
            element.detach();
        }
    }

    @Override
    public void removeFormField(String name) {
        this.envelope.removeFormValue(name);
    }
}

