/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Provider;
import com.cognos.pogo.pdk.common.Providers;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class Dom4jProviders
extends Dom4jBase
implements Providers {
    private static final List<Provider> EMPTY_LIST = Collections.emptyList();
    private final BIBusEnvelope envelope;

    public Dom4jProviders(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public List<Provider> getList() {
        List<Element> providerElementList = this.getProviderElements();
        return providerElementList != null ? this.createProviderList(providerElementList) : EMPTY_LIST;
    }

    private List<Element> getProviderElements() {
        Element providers = this.getProvidersElement();
        return providers != null ? providers.elements() : null;
    }

    private Element getProvidersElement() {
        return this.envelope.getTracking().element(BIBusEnvelope.BUS_PROVIDERS.getName());
    }

    private List<Provider> createProviderList(List<Element> providerElementList) {
        ArrayList<Provider> providerList = new ArrayList<Provider>(providerElementList.size());
        for (Element providerElement : providerElementList) {
            providerList.add(new Dom4jProvider(providerElement));
        }
        return providerList;
    }

    @Override
    public Dom4jProvider getProvider(String providerName) {
        List<Element> providerElementList = this.getProviderElements();
        return providerElementList != null ? this.findProvider(providerElementList, providerName) : null;
    }

    private Dom4jProvider findProvider(List<Element> providerElementList, String providerName) {
        for (Element providerElement : providerElementList) {
            if (!Dom4jProvider.matchesName(providerElement, providerName)) continue;
            return new Dom4jProvider(providerElement);
        }
        return null;
    }

    @Override
    public String asXML() {
        Element providers = this.getProvidersElement();
        return providers != null ? providers.asXML() : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent();
    }

    @Override
    public boolean isPresent() {
        return this.getProvidersElement() != null;
    }
}

