/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.pdk.stax.StaxBiBusHeader;
import com.cognos.pogo.pdk.stax.StaxBodyFault;
import com.cognos.pogo.pdk.stax.StaxBodyHandler;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxElement;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.NameValuePair;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class StaxEnvelope
extends BIBusEnvelope
implements StaxElement {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final String SOAPENV_NAMESPACE_PREFIX = "SOAP-ENV";
    private static final String SOAPENV_NAMESPACE_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private static final int EMPTY = 0;
    private final XMLStreamReader xmlStreamReader;
    private boolean detectedHREF = false;

    public StaxEnvelope(XMLStreamReader xmlStreamReader, BodyHandler bodyHandler) {
        super(0);
        this.createNewHeader();
        this.xmlStreamReader = xmlStreamReader;
        this.setBodyHandler(bodyHandler);
        this.setBodyFault(new StaxBodyFault());
    }

    public void parse() throws XMLStreamException {
        this.parse(this.xmlStreamReader, SOAP_ENVELOPE);
    }

    private void createNewHeader() {
        this.setBiBusHeader(new StaxBiBusHeader());
    }

    public StaxEnvelope(BodyHandler bodyHandler) {
        this((XMLStreamReader)null, bodyHandler);
    }

    public static void setLoggerForTesting(PogoLogger log) {
        BIBusEnvelope.setLoggerForTesting(log);
    }

    @Override
    public StaxBiBusHeader getBiBusHeader() {
        return (StaxBiBusHeader)super.getBiBusHeader();
    }

    @Override
    public void moveBiBusHeaderTo(Envelope target) {
        this.moveBiBusHeader((StaxEnvelope)target);
    }

    private void moveBiBusHeader(StaxEnvelope target) {
        target.setBiBusHeader(this.getBiBusHeader());
        this.createNewHeader();
    }

    @Override
    public void copyBiBusHeaderTo(Envelope target) {
        this.copyBiBusHeaderTo((StaxEnvelope)target);
    }

    public void copyBiBusHeaderTo(BIBusEnvelope target) {
        StaxBiBusHeader copy = new StaxBiBusHeader(this.getBiBusHeader());
        target.setBiBusHeader(copy);
    }

    @Override
    public void copyNamespacesTo(SOAPEnvelope destination) {
    }

    @Override
    public StaxBodyHandler getBodyHandler() {
        return (StaxBodyHandler)super.getBodyHandler();
    }

    @Override
    protected void setBodyHandler(BodyHandler bodyHandler) {
        super.setBodyHandler(bodyHandler != null ? bodyHandler : StaxBodyHandler.NULL);
    }

    @Override
    public StaxBodyFault getBodyFault() {
        return (StaxBodyFault)super.getBodyFault();
    }

    @Override
    public void copyBodyFaultTo(Envelope target) {
        StaxBodyFault copy = new StaxBodyFault(this.getBodyFault());
        target.setBodyFault(copy);
    }

    @Override
    public String toString() {
        return this.prettyPrint();
    }

    @Override
    public String getAsString(OutputFormat format) throws IOException {
        return this.prettyPrint();
    }

    @Override
    public String asXML() {
        return this.prettyPrint();
    }

    private String prettyPrint() {
        return XmlUtils.prettyPrintAndCatchException(StaxBase.toString(this));
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            this.parseElement(xsr, xsr.getLocalName());
        }
    }

    private void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        StaxUtils.detectReferences(xsr);
        if (SOAP_HEADER.equalsIgnoreCase(localName)) {
            this.parseHeader(xsr, localName);
        } else if (SOAP_BODY.equalsIgnoreCase(localName)) {
            this.parseBody(xsr, localName);
        }
    }

    private void parseHeader(XMLStreamReader xsr, String localName) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent(localName, xsr)) {
            this.parseHeaderElement(xsr, xsr.getLocalName());
        }
    }

    private void parseHeaderElement(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        StaxUtils.detectReferences(xsr);
        if (this.getBiBusHeader().canParse(entryName)) {
            this.getBiBusHeader().parse(xsr, entryName);
        }
    }

    private void parseBody(XMLStreamReader xsr, String localName) throws XMLStreamException {
        while (StaxUtils.moveToNextElementWithinParent(localName, xsr)) {
            this.parseBodyElement(xsr, xsr.getLocalName());
        }
    }

    private void parseBodyElement(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        if (this.hasBodyHandler() && this.getBodyHandler().canParse(entryName)) {
            StaxUtils.detectReferences(xsr);
            this.getBodyHandler().parse(xsr, entryName);
        } else if (this.getBodyFault().canParse(entryName)) {
            this.getBodyFault().parse(xsr, entryName);
        }
    }

    private boolean hasBodyHandler() {
        return this.getBodyHandler() != null;
    }

    @Override
    public void writeXML(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeXML(xsw, true);
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        this.writeStartEnvelope(xsw);
        this.writeHeader(xsw);
        this.writeBody(xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeHeader(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeStartHeader(xsw);
        this.getBiBusHeader().writeXML(xsw);
        xsw.writeEndElement();
    }

    private void writeBody(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeStartBody(xsw);
        if (this.hasBodyHandler()) {
            this.getBodyHandler().writeXML(xsw);
        }
        if (this.getBodyFault().isPresent()) {
            this.getBodyFault().writeXML(xsw);
        }
        xsw.writeEndElement();
    }

    @Override
    public void writeAsXML(OutputStream outStream) throws IOException {
        this.writeToStreamWriter(outStream);
    }

    @Override
    public void writeAsXML(Writer aWriter) throws IOException {
        this.writeToStreamWriter(aWriter);
    }

    private void writeToStreamWriter(Object outputter) throws IOException {
        try {
            XMLStreamWriter xsw = this.createXMLStreamWriter(outputter);
            this.writeXML(xsw);
            xsw.flush();
        }
        catch (XMLStreamException e) {
            this.getLog().warn("Error while writing XML stream", e);
            throw new IOException("Error while writing XML stream");
        }
    }

    private XMLStreamWriter createXMLStreamWriter(Object outputter) throws XMLStreamException {
        if (outputter instanceof Writer) {
            return XMLStreamFactory.createXMLStreamWriter((Writer)outputter);
        }
        if (outputter instanceof OutputStream) {
            return XMLStreamFactory.createXMLStreamWriter((OutputStream)outputter);
        }
        throw new XMLStreamException("Can't create XML stream writer. Invalid output object: " + outputter);
    }

    private void writeStartEnvelope(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(SOAPENV_NAMESPACE_PREFIX, SOAP_ENVELOPE, SOAPENV_NAMESPACE_URI);
        xsw.setPrefix(SOAPENV_NAMESPACE_PREFIX, SOAPENV_NAMESPACE_URI);
        this.writeNamespaces(xsw);
        xsw.writeAttribute(SOAPENV_NAMESPACE_PREFIX, SOAPENV_NAMESPACE_URI, "encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
    }

    private void writeNamespaces(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeNamespace(SOAPENV_NAMESPACE_PREFIX, SOAPENV_NAMESPACE_URI);
        xsw.writeNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        xsw.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xsw.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        xsw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xsw.writeNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    }

    private void writeStartHeader(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(SOAPENV_NAMESPACE_PREFIX, SOAP_HEADER, SOAPENV_NAMESPACE_URI);
    }

    private void writeStartBody(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement(SOAPENV_NAMESPACE_PREFIX, SOAP_BODY, SOAPENV_NAMESPACE_URI);
    }

    @Override
    public boolean canParse(String entryName) {
        return SOAP_ENVELOPE.equals(entryName);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getDispatcherTransportValue(String name) {
        return this.getBiBusHeader().getDispatcherTransportVars().getValue(name);
    }

    @Override
    public void setDispatcherTransport(String name, String value) {
        this.getBiBusHeader().getDispatcherTransportVars().setValue(name, value);
    }

    @Override
    public void removeDispatcherTransport(String name) {
        this.getBiBusHeader().getDispatcherTransportVars().removeValue(name);
    }

    @Override
    public String getUserPreferenceValue(String name) {
        return this.getBiBusHeader().getUserPreferenceVars().getValue(name);
    }

    @Override
    public void setUserPreference(String name, String value) {
        this.getBiBusHeader().getUserPreferenceVars().setValue(name, value);
    }

    @Override
    public String getCookieValue(String cookieName) {
        return this.getBiBusHeader().getHdrSession().getCookieVars().getValue(cookieName);
    }

    @Override
    public void setCookie(String cookieName, String cookieValue) {
        this.getBiBusHeader().getHdrSession().getCookieVars().setValue(cookieName, cookieValue);
    }

    @Override
    public String getSetCookieValue(String name) {
        return this.getBiBusHeader().getHdrSession().getSetCookieVars().getValue(name);
    }

    @Override
    public String getEnvironmentValue(String name) {
        return this.getBiBusHeader().getHdrSession().getEnvironmentVars().getValue(name);
    }

    @Override
    public void setEnvironment(String name, String value) {
        this.getBiBusHeader().getHdrSession().getEnvironmentVars().setValue(name, value);
    }

    @Override
    public void setFormField(String name, String value, String format) {
        this.getBiBusHeader().getHdrSession().getFormFieldVars().setFormField(name, value, format);
    }

    @Override
    public void addFormField(String name, String value, String format) {
        this.getBiBusHeader().getHdrSession().getFormFieldVars().addFormField(name, value, format);
    }

    @Override
    public String getFormValue(String name) {
        return this.getBiBusHeader().getHdrSession().getFormFieldVars().getValue(name);
    }

    @Override
    public String getFormFormat(String name) {
        return this.getBiBusHeader().getHdrSession().getFormFieldVars().getFormat(name);
    }

    @Override
    public void removeFormValue(String name) {
        this.getBiBusHeader().getHdrSession().getFormFieldVars().removeFormField(name);
    }

    @Override
    public List<NameValuePair> getFormFieldValues() {
        return this.getBiBusHeader().getHdrSession().getFormFieldVars().getNamesAndValues();
    }

    @Override
    public String getCAMAction() {
        String camAction = this.getBiBusHeader().getCam().getAction();
        return this.ignoreEmptyCamAction(camAction);
    }

    @Override
    public void setCAMaction(String camAction) {
        this.getBiBusHeader().getCam().setAction(camAction);
    }

    @Override
    public boolean hasCamSettingsElement() {
        return this.getBiBusHeader().getCam().getSettings().isPresent();
    }

    @Override
    public String getCAFSecureState() {
        return this.getBiBusHeader().getCaf().getSecureState();
    }

    @Override
    public void setCAFSecureState(String value) {
        this.getBiBusHeader().getCaf().setSecureState(value);
    }

    @Override
    public Element getUserCapabilitiesCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getOptionalUserCapabilitiesCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getDispatcherTransportVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getUserPreferenceVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element buildUserPreferenceVars(Element userPrefVars, Element biBusHeader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserPreferenceVars(Element userPreferenceVarsElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getCookieVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getSetCookieVar(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getSetCookieVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element setSetCookie(String name, String value, int maxAge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element setSetCookie(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getEnvironmentVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getFormFieldVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getCAM() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getOptionalCAM() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCAM(Element camElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getCAMProtect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element getEnvelope() {
        throw new UnsupportedOperationException();
    }

    public boolean isDetectedHREF() {
        return this.detectedHREF;
    }

    public void setDetectedHREF(boolean detectedHREF) {
        this.detectedHREF = detectedHREF;
    }

    @Override
    public Dom4jEnvelope toDom4j(InputStream stream) throws Exception {
        log.info("Converting STAX envelope to dom4j (using stream writer)");
        return StaxBase.toDom4j(this);
    }

    @Override
    public SOAPEnvelope fromDom4j(BIBusEnvelope envelope) throws Exception {
        return envelope.toStax(this.getBodyHandler());
    }

    @Override
    public BIBusEnvelope newBIBusEnvelope() {
        return new StaxEnvelope(null);
    }
}

