/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Dereferencer;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.CompatibleEnvelopeFactory;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.stax.StaxEnvelope;
import com.cognos.pogo.pdk.stax.StaxSoapFaultException;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.SOAPReferenceException;
import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamReader;
import org.apache.log.Priority;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class StaxEnvelopeFactory
extends CompatibleEnvelopeFactory {
    public static final int BUFFER_SIZE = 10240;
    private static final PogoLogger log = PogoLogger.getLogger();

    public static StaxEnvelope createStaxEnvelope(InputStream stream, BodyHandler bodyHandler) throws Exception {
        StaxEnvelope newStaxEnvelope = null;
        BufferedInputStream bufferedStream = null;
        try {
            stream = StaxEnvelopeFactory.logEnvelope(stream);
            bufferedStream = new BufferedInputStream(stream, 10240);
            bufferedStream.mark(10240);
            XMLStreamReader streamReader = XMLStreamFactory.createXMLStreamReader(bufferedStream);
            newStaxEnvelope = new StaxEnvelope(streamReader, bodyHandler);
            newStaxEnvelope.parse();
        }
        catch (SOAPReferenceException ref) {
            InputStream inputStream = StaxEnvelopeFactory.createNewStreamFrom(bufferedStream);
            XMLStreamReader streamReader = XMLStreamFactory.createXMLStreamReader(inputStream);
            newStaxEnvelope = new StaxEnvelope(streamReader, bodyHandler);
            newStaxEnvelope.parse();
            newStaxEnvelope.setDetectedHREF(true);
        }
        return newStaxEnvelope;
    }

    public static StaxEnvelope createStaxEnvelope(Reader reader, BodyHandler bodyHandler) throws Exception {
        StaxEnvelope newStaxEnvelope = null;
        BufferedReader bufferedReader = null;
        try {
            reader = StaxEnvelopeFactory.logEnvelope(reader);
            bufferedReader = new BufferedReader(reader, 10240);
            bufferedReader.mark(10240);
            XMLStreamReader streamReader = XMLStreamFactory.createXMLStreamReader(bufferedReader);
            newStaxEnvelope = new StaxEnvelope(streamReader, bodyHandler);
            newStaxEnvelope.parse();
        }
        catch (SOAPReferenceException ref) {
            InputStream inputStream = StaxEnvelopeFactory.createNewStreamFrom(bufferedReader);
            XMLStreamReader streamReader = XMLStreamFactory.createXMLStreamReader(inputStream);
            newStaxEnvelope = new StaxEnvelope(streamReader, bodyHandler);
            newStaxEnvelope.parse();
            newStaxEnvelope.setDetectedHREF(true);
        }
        return newStaxEnvelope;
    }

    public static StaxEnvelope createStaxEnvelope() {
        log.debug("Creating empty StaxEnvelope");
        return new StaxEnvelope(null);
    }

    @Override
    public StaxEnvelope createEnvelope(BodyHandler bodyHandler) {
        return StaxEnvelopeFactory.createStaxEnvelope(bodyHandler);
    }

    public static StaxEnvelope createStaxEnvelope(BodyHandler bodyHandler) {
        log.debug("Creating empty StaxEnvelope with BodyHandler ", bodyHandler);
        return new StaxEnvelope(bodyHandler);
    }

    @Override
    public StaxEnvelope createEnvelope(InputStream stream, BodyHandler bodyHandler) throws Exception {
        if (this.isLocal(stream)) {
            log.debug("Trying to reuse envelope from local response stream");
            return (StaxEnvelope)this.getLocalResponseEnvelope(stream).toStax(bodyHandler);
        }
        log.debug("Creating StaxEnvelope from InputStream");
        return StaxEnvelopeFactory.createStaxEnvelope(stream, bodyHandler);
    }

    @Override
    public StaxEnvelope createEnvelope(Reader reader, BodyHandler bodyHandler) throws Exception {
        log.debug("Creating StaxEnvelope from Reader");
        return StaxEnvelopeFactory.createStaxEnvelope(reader, bodyHandler);
    }

    @Override
    public StaxEnvelope createEnvelope(String xml, BodyHandler bodyHandler) throws Exception {
        log.debug("Creating StaxEnvelope from XML string");
        return StaxEnvelopeFactory.createStaxEnvelope(xml, bodyHandler);
    }

    public static StaxEnvelope createStaxEnvelope(String xml, BodyHandler bodyHandler) throws Exception {
        StringReader stringReader = new StringReader(xml);
        return StaxEnvelopeFactory.createStaxEnvelope(stringReader, bodyHandler);
    }

    @Override
    public boolean isCompatibleWith(Envelope envelope) {
        return envelope instanceof StaxEnvelope;
    }

    @Override
    public StaxSoapFaultException createSoapFaultException(BodyFault bodyFault) {
        return new StaxSoapFaultException(bodyFault);
    }

    private static String convertReaderToString(Reader reader) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            StaxEnvelopeFactory.copyReaderToWriter(reader, writer);
        }
        finally {
            reader.close();
        }
        return ((Object)writer).toString();
    }

    private static void copyReaderToWriter(Reader reader, Writer writer) throws IOException {
        int bytesRead;
        char[] buffer = new char[10240];
        BufferedReader bufferedReader = new BufferedReader(reader, 10240);
        while ((bytesRead = bufferedReader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    private static InputStream logEnvelope(InputStream inputStream) throws UnsupportedEncodingException, Exception {
        if (!log.isDebugEnabled()) {
            return inputStream;
        }
        String envelope = StaxEnvelopeFactory.convertReaderToString(new InputStreamReader(inputStream, "UTF-8"));
        log.debug(envelope);
        return new ByteArrayInputStream(envelope.getBytes("UTF-8"));
    }

    private static Reader logEnvelope(Reader inputReader) throws Exception {
        if (!log.isDebugEnabled()) {
            return inputReader;
        }
        String envelope = StaxEnvelopeFactory.convertReaderToString(inputReader);
        log.debug(envelope);
        return new StringReader(envelope);
    }

    private static InputStream createNewStreamFrom(BufferedReader originalReader) throws IOException, DocumentException {
        Document requestDocument = StaxEnvelopeFactory.readRequestDocument(originalReader);
        return StaxEnvelopeFactory.dereferenceDocument(requestDocument);
    }

    private static Document readRequestDocument(BufferedReader originalReader) throws IOException, DocumentException {
        SAXReader saxReader = new SAXReader();
        originalReader.reset();
        return saxReader.read((Reader)originalReader);
    }

    private static InputStream dereferenceDocument(Document requestDocument) {
        Dereferencer dereferencer = new Dereferencer();
        return (requestDocument = dereferencer.dereference(requestDocument)) != null ? new ByteArrayInputStream(requestDocument.asXML().getBytes()) : null;
    }

    private static InputStream createNewStreamFrom(BufferedInputStream originalStream) throws IOException, DocumentException {
        Document requestDocument = StaxEnvelopeFactory.readRequestDocument(originalStream);
        return StaxEnvelopeFactory.dereferenceDocument(requestDocument);
    }

    private static Document readRequestDocument(BufferedInputStream originalStream) throws IOException, DocumentException {
        SAXReader saxReader = new SAXReader();
        originalStream.reset();
        return saxReader.read((InputStream)originalStream);
    }

    @Override
    public String getParserType() {
        return "stax";
    }

    @Override
    public Envelope convertEnvelope(BIBusEnvelope envelope, BodyHandler bodyHandler, InputStream inputStream) throws Exception {
        log.debug("Converting ", envelope.getClass().getSimpleName(), " to StaxEnvelope.");
        return envelope.toStax(bodyHandler, inputStream);
    }
}

