/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.stax.StaxFormFieldVarsMapEntry;
import com.cognos.pogo.stax.utils.StaxMapEntry;
import com.cognos.pogo.stax.utils.StaxVarsList;
import com.cognos.pogo.util.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxFormFieldVarsMap
extends StaxVarsList {
    private static final String FORM_FIELD_VARS = "formFieldVars";

    public StaxFormFieldVarsMap() {
    }

    public StaxFormFieldVarsMap(StaxFormFieldVarsMap source) {
        super(source);
    }

    @Override
    protected StaxFormFieldVarsMapEntry createMapEntry() {
        return new StaxFormFieldVarsMapEntry();
    }

    @Override
    protected StaxFormFieldVarsMapEntry cloneMapEntry(StaxMapEntry source) {
        return new StaxFormFieldVarsMapEntry((StaxFormFieldVarsMapEntry)source);
    }

    @Override
    public StaxFormFieldVarsMapEntry get(String key) {
        return (StaxFormFieldVarsMapEntry)super.get(key);
    }

    @Override
    public boolean canParse(String entryName) {
        return FORM_FIELD_VARS.equals(entryName);
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        super.writeXML(xsw, FORM_FIELD_VARS, writeNamespace);
    }

    public String getValue(String name) {
        StaxFormFieldVarsMapEntry entry = this.get(name);
        return entry != null ? entry.getValue() : null;
    }

    public String getFormat(String name) {
        StaxFormFieldVarsMapEntry entry = this.get(name);
        return entry != null ? entry.getFormat() : null;
    }

    public List<NameValuePair> getNamesAndValues() {
        Collection<StaxMapEntry> formFields = this.getValues();
        ArrayList<NameValuePair> namesAndValues = new ArrayList<NameValuePair>(formFields.size());
        for (StaxMapEntry formField : formFields) {
            this.addToList(formField, namesAndValues);
        }
        return namesAndValues;
    }

    private void addToList(StaxMapEntry entry, List<NameValuePair> list) {
        StaxFormFieldVarsMapEntry mapEntry = (StaxFormFieldVarsMapEntry)entry;
        NameValuePair pair = new NameValuePair(mapEntry.getName(), mapEntry.getValue());
        list.add(pair);
    }

    public void setFormField(String name, String value, String format) {
        this.remove(name);
        this.add(new StaxFormFieldVarsMapEntry(name, value, format));
    }

    public void addFormField(String name, String value, String format) {
        this.add(new StaxFormFieldVarsMapEntry(name, value, format));
    }

    public void importFormFieldVarsFrom(StaxFormFieldVarsMap source) {
        this.clear();
        for (StaxMapEntry entry : source.getValues()) {
            this.add(entry);
        }
    }
}

