/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.Provider;
import com.cognos.pogo.stax.utils.StaxMapEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxProvider
extends StaxMapEntry
implements Provider {
    private static final String BUILD = "build";
    private static final String PATCH = "patch";
    private String name;
    private String build;
    private Integer patch;

    public StaxProvider() {
    }

    public StaxProvider(String name, String build, Integer patch) {
        this.name = name;
        this.build = build;
        this.patch = patch;
    }

    public StaxProvider(StaxProvider source) {
        this(source.name, source.build, source.patch);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBuild() {
        return this.build;
    }

    @Override
    public int getPatch() {
        return this.patch != null ? this.patch : 0;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean canParse(String entryName) {
        return true;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("name".equals(localName)) {
            this.name = xsr.getElementText();
        } else if (BUILD.equals(localName)) {
            this.build = xsr.getElementText();
        } else if (PATCH.equals(localName)) {
            this.patch = StaxProvider.parseInteger(xsr);
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxProvider.writeIntElement(PATCH, this.patch, xsw);
        StaxProvider.writeStringElement(BUILD, this.build, xsw);
    }
}

