/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.pdk.common.CamProtect;
import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxCamProtect
extends StaxBase
implements CamProtect {
    private static final String CAM_PROTECT = "CAMProtect";
    private static final String TRUSTED_VALUE = "trustedValue";
    private static final String SERVICE_ID = "serviceId";
    private String serviceId;
    private String trustedValue;

    public StaxCamProtect() {
    }

    public StaxCamProtect(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, CAM_PROTECT);
    }

    public StaxCamProtect(StaxCamProtect source) {
        this.serviceId = source.serviceId;
        this.trustedValue = source.trustedValue;
    }

    @Override
    public boolean isPresent() {
        return this.serviceId != null || this.trustedValue != null;
    }

    @Override
    public boolean canParse(String entryName) {
        return CAM_PROTECT.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (localName.equals(SERVICE_ID)) {
            this.serviceId = xsr.getElementText();
        } else if (localName.equals(TRUSTED_VALUE)) {
            this.trustedValue = xsr.getElementText();
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxCamProtect.writeStartBusElement(CAM_PROTECT, CAM_PROTECT, writeNamespace, xsw);
        StaxCamProtect.writeStringElement(SERVICE_ID, this.serviceId, xsw);
        StaxCamProtect.writeBase64BinaryElement(TRUSTED_VALUE, this.trustedValue, xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getTrustedValue() {
        return this.trustedValue;
    }

    @Override
    public void clear() {
        this.serviceId = null;
        this.trustedValue = null;
    }
}

