/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.pdk.common.CamException;
import com.cognos.pogo.pdk.stax.cam.StaxMessages;
import com.cognos.pogo.pdk.stax.cam.StaxPromptInfo;
import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxException
extends StaxBase
implements CamException {
    public static final StaxException NULL = new StaxException();
    private String errorCode;
    private String errorCodeString;
    private String severity;
    private StaxPromptInfo promptInfo = StaxPromptInfo.NULL;
    private StaxMessages messages = StaxMessages.NULL;
    private boolean isPresent;

    public StaxException() {
    }

    public StaxException(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, "exception");
        this.isPresent = true;
    }

    public StaxException(StaxException source) {
        this.errorCode = source.errorCode;
        this.errorCodeString = source.errorCodeString;
        this.severity = source.severity;
        this.promptInfo = source.promptInfo == StaxPromptInfo.NULL ? StaxPromptInfo.NULL : new StaxPromptInfo(source.promptInfo);
        this.messages = source.messages == StaxMessages.NULL ? StaxMessages.NULL : new StaxMessages(source.messages);
        this.isPresent = source.isPresent;
    }

    @Override
    public boolean isPresent() {
        return this.isPresent;
    }

    @Override
    public boolean canParse(String entryName) {
        return "exception".equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if ("errorCode".equals(localName)) {
            this.errorCode = xsr.getElementText();
        } else if ("errorCodeString".equals(localName)) {
            this.errorCodeString = xsr.getElementText();
        } else if ("severity".equals(localName)) {
            this.severity = xsr.getElementText();
        } else if (this.messages.canParse(localName)) {
            this.messages = new StaxMessages(xsr);
        } else if (this.promptInfo.canParse(localName)) {
            this.promptInfo = new StaxPromptInfo(xsr);
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxException.writeStartBusElement("exception", "CAMException", writeNamespace, xsw);
        StaxException.writeElement("severity", this.severity, "severityEnum", "bus", xsw);
        StaxException.writeStringElement("errorCode", this.errorCode, xsw);
        StaxException.writeStringElement("errorCodeString", this.errorCodeString, xsw);
        StaxException.writeChildXML(this.messages, xsw);
        StaxException.writeChildXML(this.promptInfo, xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorCodeString() {
        return this.errorCodeString;
    }

    public String getSeverity() {
        return this.severity;
    }

    public StaxPromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public StaxMessages getMessages() {
        return this.messages;
    }

    @Override
    public String getNamespace() {
        return this.getPromptInfo().getNamespace();
    }

    @Override
    public String getSecurityBlob() {
        return this.getPromptInfo().getSecurityBlob();
    }
}

