/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.pdk.stax.cam.StaxCaptions;
import com.cognos.pogo.pdk.stax.cam.StaxDisplayObjects;
import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxPromptInfo
extends StaxBase {
    public static final StaxPromptInfo NULL = new StaxPromptInfo();
    private static final String PROMPT_INFO = "promptInfo";
    private static final String SECURITY_BLOB = "securityBlob";
    private StaxCaptions captions = StaxCaptions.NULL;
    private StaxDisplayObjects displayObjects = StaxDisplayObjects.NULL;
    private String securityBlob;

    public StaxPromptInfo() {
    }

    public StaxPromptInfo(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, PROMPT_INFO);
    }

    public StaxPromptInfo(StaxPromptInfo source) {
        this.captions = source.captions == StaxCaptions.NULL ? StaxCaptions.NULL : new StaxCaptions(source.captions);
        this.displayObjects = source.displayObjects == StaxDisplayObjects.NULL ? StaxDisplayObjects.NULL : new StaxDisplayObjects(source.displayObjects);
        this.securityBlob = source.securityBlob;
    }

    @Override
    public boolean canParse(String entryName) {
        return PROMPT_INFO.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (this.getCaptions().canParse(localName)) {
            this.captions = new StaxCaptions(xsr);
        } else if (this.getDisplayObjects().canParse(localName)) {
            this.displayObjects = new StaxDisplayObjects(xsr);
        } else if (SECURITY_BLOB.equals(localName)) {
            this.securityBlob = xsr.getElementText();
        }
    }

    @Override
    public boolean isPresent() {
        return this.getSecurityBlob() != null || this.getCaptions().isPresent() || this.getDisplayObjects().isPresent();
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxPromptInfo.writeStartBusElement(PROMPT_INFO, PROMPT_INFO, writeNamespace, xsw);
        StaxPromptInfo.writeChildXML(this.getCaptions(), xsw);
        StaxPromptInfo.writeBase64BinaryElement(SECURITY_BLOB, this.getSecurityBlob(), xsw);
        StaxPromptInfo.writeChildXML(this.getDisplayObjects(), xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    public StaxCaptions getCaptions() {
        return this.captions;
    }

    public StaxDisplayObjects getDisplayObjects() {
        return this.displayObjects;
    }

    public String getSecurityBlob() {
        return this.securityBlob;
    }

    public String getNamespace() {
        return this.getDisplayObjects().getNamespace();
    }
}

