/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxPromptOptionsEntry
extends StaxBase {
    private static final String DEFAULT = "default";
    private static final String ID = "id";
    private String value;
    private String id;
    private Boolean defaultValue;

    public StaxPromptOptionsEntry(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.parse(xsr, entryName);
    }

    public StaxPromptOptionsEntry(StaxPromptOptionsEntry source) {
        this.value = source.value;
        this.id = source.id;
        this.defaultValue = source.defaultValue;
    }

    @Override
    public boolean canParse(String entryName) {
        return true;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (ID.equals(localName)) {
            this.id = xsr.getElementText();
        } else if (DEFAULT.equals(localName)) {
            this.defaultValue = StaxPromptOptionsEntry.parseBoolean(xsr);
        } else if ("value".equals(localName)) {
            this.value = xsr.getElementText();
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxPromptOptionsEntry.writeBooleanElement(DEFAULT, this.defaultValue, xsw);
        StaxPromptOptionsEntry.writeStringElement(ID, this.id, xsw);
        StaxPromptOptionsEntry.writeStringElement("value", this.value, xsw);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getDefault() {
        return this.defaultValue;
    }
}

