/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.util;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.FormFieldVars;
import com.cognos.pogo.util.NameValuePair;
import org.dom4j.Element;

public class SOAPPasswordCleaner {
    private static final String OBSCURED_PASSWORD = "********";

    public static boolean removePassword(BIBusEnvelope safeEnvelope) {
        return SOAPPasswordCleaner.removeCamPassword(safeEnvelope) || SOAPPasswordCleaner.removeFormPasswords(safeEnvelope) || SOAPPasswordCleaner.removeFromBodyCredentials(safeEnvelope);
    }

    protected static boolean removeCamPassword(BIBusEnvelope safeEnvelope) {
        String camXml;
        boolean cleaned = false;
        Cam cam = safeEnvelope.getBiBusHeader().getCam();
        if (cam.isPresent() && (camXml = cam.asXML()).contains("assword")) {
            Element camElement = safeEnvelope.getCAM();
            for (Object object : camElement.selectNodes("//password")) {
                Element passwordElement = (Element)object;
                passwordElement.setText(OBSCURED_PASSWORD);
                cleaned = true;
            }
        }
        return cleaned;
    }

    protected static boolean removeFormPasswords(BIBusEnvelope safeEnvelope) {
        boolean cleaned = false;
        FormFieldVars formFieldVars = safeEnvelope.getBiBusHeader().getHdrSession().getFormFieldVars();
        for (NameValuePair nameValuePair : formFieldVars.getNamesAndValues()) {
            if (!nameValuePair.getName().matches(".*[Pp]assword")) continue;
            formFieldVars.removeFormField(nameValuePair.getName());
            formFieldVars.setFormField(nameValuePair.getName(), OBSCURED_PASSWORD);
            cleaned = true;
        }
        return cleaned;
    }

    private static boolean removeFromBodyCredentials(BIBusEnvelope safeEnvelope) {
        boolean cleaned = false;
        Element body = safeEnvelope.getBody();
        if (safeEnvelope.getFaultCode() == null && body.asXML().contains("assword")) {
            ((Element)body.elements().get(0)).detach();
            body.setText("******** passwords removed ********");
            cleaned = true;
        }
        return cleaned;
    }
}

