/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ReportServerProcess;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ProcessReaper
extends SafeThread {
    private static final PogoLogger log = PogoLogger.getLogger();
    private volatile boolean isRunning;
    List<ProcessFacade> liveProcessList = new LinkedList<ProcessFacade>();
    List<DeadProcess> deadProcessList = new LinkedList<DeadProcess>();
    List<DeadProcess> recentArrivals = new LinkedList<DeadProcess>();
    private int shutdownTimeLimit = 300000;

    public ProcessReaper(String name) {
        super(name);
        this.setDaemon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLiveProcess(ProcessFacade proc) {
        List<ProcessFacade> list = this.liveProcessList;
        synchronized (list) {
            this.liveProcessList.add(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLiveList(ProcessFacade proc) {
        List<ProcessFacade> list = this.liveProcessList;
        synchronized (list) {
            this.liveProcessList.remove(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZombieProcesses(List<ProcessFacade> processesToKill, int timeLimit) {
        if (!this.isRunning) {
            for (ProcessFacade proc : processesToKill) {
                log.debug("add called when shutdown, killing: ", proc);
                proc.kill();
            }
            return;
        }
        List<DeadProcess> list = this.recentArrivals;
        synchronized (list) {
            for (ProcessFacade proc : processesToKill) {
                this.recentArrivals.add(new DeadProcess(proc, timeLimit));
                this.removeFromLiveList(proc);
            }
            this.recentArrivals.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZombieProcess(ProcessFacade proc, int timeLimitSec) {
        if (!this.isRunning) {
            log.debug("add called when shutdown, killing: ", proc);
            ReportServerProcess.logReportServerStatus(this.getClass().getName(), false, "BIBus.stopDueToException", new Object[]{proc.getProcessName(), String.valueOf(proc.getProcessID())});
            proc.kill();
        }
        List<DeadProcess> list = this.recentArrivals;
        synchronized (list) {
            this.recentArrivals.add(new DeadProcess(proc));
            this.removeFromLiveList(proc);
            this.recentArrivals.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyProcesses(boolean waitForProcessesToDie) {
        List<DeadProcess> list = this.recentArrivals;
        synchronized (list) {
            this.deadProcessList.addAll(this.recentArrivals);
            this.recentArrivals.clear();
        }
        if (this.deadProcessList.isEmpty()) {
            log.debug("deadProcessList is empty. No processes to destroy.");
            return;
        }
        for (DeadProcess dp : this.deadProcessList) {
            if (dp.stopSent || dp.getTimeLimit() == 0) continue;
            dp.process.sendStop();
            dp.stopSent = true;
        }
        ListIterator<DeadProcess> itProcesses = this.deadProcessList.listIterator();
        while (itProcesses.hasNext()) {
            DeadProcess dp;
            dp = itProcesses.next();
            if (!this.checkProcessIsDead(dp, waitForProcessesToDie)) continue;
            itProcesses.remove();
        }
    }

    boolean checkProcessIsDead(DeadProcess deadProcess, boolean waitForProcessesToDie) {
        while (true) {
            try {
                deadProcess.process.exitValue();
                log.debug("process has exited: ", deadProcess.process);
                return true;
            }
            catch (IllegalThreadStateException itsx) {
                log.debug("process has not yet exited: ", deadProcess.process);
                if (System.currentTimeMillis() >= deadProcess.ageLimit) {
                    log.info("Process (", deadProcess.process, ") did not shutdown within the timelimit.  Terminating process forcefully.");
                    ReportServerProcess.logReportServerStatus(this.getClass().getName(), false, "BIBus.stoppedDueToTimeLimit", new Object[]{deadProcess.process.getProcessName(), String.valueOf(deadProcess.process.getProcessID()), String.valueOf(this.shutdownTimeLimit)});
                    deadProcess.process.kill();
                }
                if (waitForProcessesToDie) {
                    log.debug("waiting for process to exit");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                return false;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void safeRun() {
        while (this.isRunning()) {
            this.destroyProcesses(false);
            try {
                List<DeadProcess> list = this.recentArrivals;
                synchronized (list) {
                    if (this.isRunning() && this.recentArrivals.size() > 0) {
                        continue;
                    }
                    if (this.isRunning() && this.deadProcessList.size() > 0) {
                        this.recentArrivals.wait(2000L);
                    } else if (this.isRunning()) {
                        this.recentArrivals.wait(30000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.killAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAll() {
        log.debug("killAll on thread exit");
        if (this.liveProcessList.size() > 0) {
            log.debug("processes were left on the live list at shutdown, will kill them.");
            List<ProcessFacade> list = this.liveProcessList;
            synchronized (list) {
                for (ProcessFacade aProcess : this.liveProcessList) {
                    this.deadProcessList.add(new DeadProcess(aProcess));
                }
                this.liveProcessList.clear();
            }
        }
        this.destroyProcesses(true);
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.setRunning(false);
        List<DeadProcess> list = this.recentArrivals;
        synchronized (list) {
            this.recentArrivals.notify();
        }
    }

    void setRunning(boolean b) {
        this.isRunning = b;
    }

    @Override
    public synchronized void start() {
        this.setRunning(true);
        super.start();
    }

    public int getShutdownTimeLimit() {
        return this.shutdownTimeLimit;
    }

    public void setShutdownTimeLimit(int shutdownTimeLimit) {
        this.shutdownTimeLimit = shutdownTimeLimit;
    }

    private class DeadProcess {
        boolean stopSent = false;
        ProcessFacade process;
        long ageLimit;
        private int timeLimit;

        DeadProcess(ProcessFacade process) {
            this(process, processReaper.shutdownTimeLimit);
        }

        DeadProcess(ProcessFacade process, int timeLimit) {
            this.process = process;
            this.timeLimit = timeLimit;
            this.setAgeLimit(timeLimit);
            log.info("Process (", process.getProcessID(), ") is scheduled for shutdown within ", timeLimit == -1 ? ProcessReaper.this.shutdownTimeLimit : timeLimit, " milliseconds unless it is not idle");
        }

        private void setAgeLimit(int timeLimit) {
            this.ageLimit = timeLimit == -1 ? System.currentTimeMillis() + (long)ProcessReaper.this.shutdownTimeLimit : System.currentTimeMillis() + (long)timeLimit;
        }

        public int getTimeLimit() {
            return this.timeLimit;
        }
    }
}

