/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.pdk.Configuration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ReportServerAttributeMonitor {
    private String[] _ignoredNames = new String[]{"rsAffineConnections", "rsPeakAffineConnections", "rsNonAffineConnections", "rsPeakNonAffineConnections", "rsMaximumProcesses", "rsPeakMaximumProcesses", "brsAffineConnections", "brsPeakAffineConnections", "brsNonAffineConnections", "brsPeakNonAffineConnections", "brsMaximumProcesses", "brsPeakMaximumProcesses", "rsQueueLimit"};
    private String[] _additionalNames = new String[]{"periodicalDocumentVersionRetentionAge", "periodicalDocumentVersionRetentionCount", "rsAuditLevel", "rsAuditNativeQuery", "brsAuditLevel", "brsAuditNativeQuery"};
    private HashMap<String, String> attributeNames = new HashMap();

    protected String[] getIgnoredNames() {
        return this._ignoredNames;
    }

    protected String[] getAdditionalNames() {
        return this._additionalNames;
    }

    public ReportServerAttributeMonitor(Element config) {
        this.getAttributeNames(config);
        this.removeIgnoredNames();
        this.addAdditionalNames();
    }

    public ReportServerAttributeMonitor() {
    }

    private void getAttributeNames(Element config) {
        for (Element attributeElement : this.getAttributes(config)) {
            String attributeName = attributeElement.getTextTrim();
            this.attributeNames.put(attributeName, null);
        }
    }

    private List<Element> getAttributes(Element config) {
        Element attributesElement = (Element)config.selectSingleNode("//attributes");
        return attributesElement.elements();
    }

    private void removeIgnoredNames() {
        String[] ignoredNames = this.getIgnoredNames();
        for (int i = 0; i < ignoredNames.length; ++i) {
            this.attributeNames.remove(ignoredNames[i]);
        }
    }

    private void addAdditionalNames() {
        String[] additionalNames = this.getAdditionalNames();
        for (int i = 0; i < additionalNames.length; ++i) {
            this.attributeNames.put(additionalNames[i], null);
        }
    }

    public int getSize() {
        return this.attributeNames.size();
    }

    public boolean checkConfiguration(Configuration configuration) {
        boolean changed = false;
        for (Map.Entry<String, String> entry : this.attributeNames.entrySet()) {
            boolean entryChanged = this.checkEntry(configuration, entry);
            changed |= entryChanged;
        }
        return changed;
    }

    private boolean checkEntry(Configuration configuration, Map.Entry<?, ?> entry) {
        String name = (String)entry.getKey();
        String oldValue = (String)entry.getValue();
        String newValue = configuration.getValue(name);
        return this.updateValueIfChanged(name, oldValue, newValue);
    }

    private boolean updateValueIfChanged(String key, String oldValue, String newValue) {
        boolean changed = false;
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.attributeNames.put(key, newValue);
            changed = this.checkValueIsNotNull(oldValue);
        }
        return changed;
    }

    private boolean checkValueIsNotNull(String value) {
        return value != null;
    }
}

