/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.QueueableRequestReportingHandler;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportGeneralList;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportMonitor;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.BodyHandlerFactory;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.reportservice.AdvancedSettingsConfigurationChange;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerAttributeMonitor;
import com.cognos.pogo.reportservice.ReportServerBodyHandler;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.reportservice.RequestInvoker;
import com.cognos.pogo.reportservice.temporary.TemporaryObjectsControl;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.ProcessExecutionMode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.apache.log.Logger;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ReportServerHandler
extends BasicHandler
implements IRSHandler,
BodyHandlerFactory {
    private static final PogoLogger log = PogoLogger.getLogger();
    private RSComponentFactory rsComponentFactory;
    private static final String INTERACTIVE_PROCESS_USE_LIMIT = "DISP.InteractiveProcessUseLimit";
    private static final String PARTIALSAXREADER_LIMIT_MB_SETTING = "DISP.PartialSaxReaderMBLimit";
    private static final String DUPLICATED_REQUEST_SUSPENSION_IN_SECS = "DISP.DuplicatedRequest_Suspension_In_secs";
    private static final String REPORT_SERVER_MODE_INTERACTIVE = "Interactive";
    protected static final int DEFAULT_NOTIFICATION_INTERVAL = 60000;
    protected ProcessManager aProcessManager;
    protected ReportServerQueue aReportServerQueue;
    private QueueableRequestReportingHandler queueableReportingHandler;
    private boolean prestartProcess;
    private int partialSaxLimit = -1;
    private int duplicatedRequestSuspensionInSeconds = -1;
    public Configuration localConfiguration;
    private ICCLConfiguration cclConfiguration;
    private InteractiveReportMonitor interactiveReportMonitor;
    private long defaultTimeout = 30000L;
    private boolean usessl;
    private long requestExpirationTime = 30000L;
    ReportServerInProgressRequests inProgressRequests;
    private InteractiveReportExecutingRequests executingRequests;
    private RequestInvoker requestInvoker;
    protected int notificationTimeInterval = 60000;
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final int DEFAULT_SHUTDOWN_IMMEDIATE_TIME_LIMIT = 10000;
    private static final String REPORT_SERVICE_NAME = "reportService";
    private String errorMessageCodePrefix = "ReportServerHandler.";
    protected ReportServerAttributeMonitor reportServerAttributeMonitor;
    protected AdvancedSettingsConfigurationChange advancedSettingsConfigurationChange;
    private int shutdownImmediateTimeLimit = 10000;
    private TemporaryObjectsControl temporaryObjectsControl;
    private int bibusThreads = 10;

    public ReportServerHandler() {
        this(log.getNativeLogger());
    }

    public ReportServerHandler(Logger aLogger) {
        this(aLogger, CCLConfigurationFactory.getInstance());
    }

    public ReportServerHandler(Logger aLogger, ICCLConfiguration cclConfiguration) {
        super(aLogger);
        this.cclConfiguration = cclConfiguration;
        this.temporaryObjectsControl = new TemporaryObjectsControl();
    }

    public ReportServerHandler(ICCLConfiguration cclConfiguration) {
        this(log.getNativeLogger(), cclConfiguration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        PerformanceEventListener pi = PerformanceIndicator.getListener();
        pi.cancelSummaryMode();
        mc.setProperty("envelope.bodyHandlerFactory", this);
        this.requestInvoker.invoke(mc);
    }

    public void getOutput(MessageContext mc, MethodDispatcherCacheExtractor mdce) {
        this.requestInvoker.getOutput(mc, mdce);
    }

    protected void setRequestInvoker(RequestInvoker ri) {
        this.requestInvoker = ri;
    }

    protected InteractiveReportExecutingRequests getExecutingRequests() {
        return this.executingRequests;
    }

    protected Map<String, String> getInitParams(List<Element> initParamList) {
        if (initParamList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> initParamsMap = new HashMap<String, String>(initParamList.size());
        for (Element initParamElement : initParamList) {
            initParamsMap.put(initParamElement.elementTextTrim("param-name"), initParamElement.elementTextTrim("param-value"));
        }
        return initParamsMap;
    }

    @Override
    public ReportServerQueue getReportServerQueue() {
        return this.aReportServerQueue;
    }

    protected String[] getProcessArguments(List<Element> childProcCmdList, Map<String, String> initParamMap, ProcessExecutionMode processExecutionMode) {
        ArrayList<String> argList = new ArrayList<String>();
        String exeName = processExecutionMode.getProcessName();
        argList.add(exeName);
        argList.add("threads=" + this.bibusThreads);
        argList.add("camssl=" + (this.usessl ? "true" : "false"));
        argList.add("COG_ROOT=");
        for (Element childProcCmd : childProcCmdList) {
            argList.add(childProcCmd.getTextTrim());
        }
        try {
            int lightThreads = this.getIntInitParam(initParamMap, "light_threads");
            if (lightThreads > 0) {
                argList.add("lightthreads=" + Integer.toString(lightThreads));
            }
        }
        catch (NumberFormatException lightThreads) {
            // empty catch block
        }
        String[] args = new String[argList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (String)argList.get(i);
        }
        return args;
    }

    @Override
    public void configure(Configuration configuration) {
        if (configuration == null) {
            return;
        }
        this.updateConfig(configuration);
        this.setDispatcherGuid(NodeID.getSelf().getGuid());
        Element configurationFromCM = configuration.getCmResponse();
        configurationFromCM = this.configureReportServerType(configurationFromCM);
        this.aProcessManager.setCclConfiguration(configurationFromCM);
        boolean inPeakDemandPeriod = "true".equalsIgnoreCase(configuration.getValue("inPeakDemandPeriod"));
        this.temporaryObjectsControl.configure(configuration);
        this.aProcessManager.updateActiveCM(configuration.getValue("contentManager"));
        int nonAffineConnections = this.getConnectionsFromConfiguration(configuration, inPeakDemandPeriod);
        int maxProcess = this.getMaxProcessesFromConfig(configuration, inPeakDemandPeriod);
        this.getServicePropertiesFromConfiguration(configuration);
        boolean advancedSettingsChanged = this.advancedSettingsConfigurationChange.check(configuration);
        if (advancedSettingsChanged) {
            try {
                int processUseLimit = this.advancedSettingsConfigurationChange.extractProcessUseLimit(this.getProcessUseLimitPropertyName());
                if (processUseLimit > 0) {
                    this.aProcessManager.setRequestCountLimit(processUseLimit);
                }
                this.partialSaxLimit = this.advancedSettingsConfigurationChange.extractPartialSaxLimit(this.getPartialSaxReaderMBLimitPropertyName());
                this.requestInvoker.setPartialSaxLimit(this.partialSaxLimit);
                this.duplicatedRequestSuspensionInSeconds = this.advancedSettingsConfigurationChange.extractDuplicatedRequestSuspensionInSeconds(this.getDuplicated_Requeset_Suspension_In_secs());
            }
            catch (DocumentException e) {
                log.warn("Error parsing Advanced Settings ", e);
            }
        }
        if (advancedSettingsChanged || this.isConfigurationChanged(configuration)) {
            this.aProcessManager.setConfigurationChanged();
        }
        this.aProcessManager.useNewConfiguration();
        this.notifyCapacity(configuration, nonAffineConnections, maxProcess);
    }

    private void updateConfig(Configuration configuration) {
        this.localConfiguration = configuration;
        this.cclConfiguration = this.localConfiguration.getICCLConfiguration();
    }

    private boolean isConfigurationChanged(Configuration configuration) {
        return this.reportServerAttributeMonitor != null && this.reportServerAttributeMonitor.checkConfiguration(configuration);
    }

    protected void getServicePropertiesFromConfiguration(Configuration configuration) {
        try {
            int queueLimit = this.getQueueLimitTime(configuration);
            if (Check.isValidTimeoutValue(queueLimit)) {
                this.setDefaultTimeout(queueLimit);
                this.aReportServerQueue.setDefaultTimeout(queueLimit);
            }
        }
        catch (NumberFormatException ex) {
            log.warn("Configuration property 'rsQueueLimit' is not an integer.  Ignoring configuration update");
        }
        try {
            int executionLimit = this.getExecutionTimeLimit(configuration);
            log.debug("Using execution time limit (in seconds): ", executionLimit);
            this.inProgressRequests.setExecutionTimeLimit(executionLimit);
        }
        catch (NumberFormatException ex) {
            log.warn("Configuration property 'rsExecutionTimeLimit' is not an integer.  Ignoring configuration update");
        }
    }

    protected int getMaxProcessesFromConfig(Configuration configuration, boolean inPeakDemandPeriod) {
        int maxProcess = 0;
        try {
            maxProcess = inPeakDemandPeriod ? this.getPeakMaxProcessProperty(configuration) : this.getMaxProcessProperty(configuration);
            this.aProcessManager.setMaxProcessCount(maxProcess);
        }
        catch (NumberFormatException ex) {
            log.warn("Configuration property 'rsMaximumProcesses' is not an integer.  Ignoring configuration update");
        }
        return maxProcess;
    }

    protected int getConnectionsFromConfiguration(Configuration configuration, boolean inPeakDemandPeriod) {
        int nonAffineConnections = 0;
        try {
            int affineConnections;
            if (inPeakDemandPeriod) {
                affineConnections = this.getPeakAffineConnectionsProperty(configuration);
                nonAffineConnections = this.getPeakNonAffineConnectionsProperty(configuration);
            } else {
                affineConnections = this.getAffineConnectionsProperty(configuration);
                nonAffineConnections = this.getNonAffineConnectionsProperty(configuration);
            }
            this.aProcessManager.updateConnectionsPerProcess(affineConnections, nonAffineConnections);
        }
        catch (NumberFormatException ex) {
            log.warn("Configuration connection properties did not return integers.  Ignoring configuration update");
        }
        return nonAffineConnections;
    }

    public void notifyCapacity(Configuration configuration, int nonAffineConnections, int maxProcess) {
    }

    @Override
    public String getProcessUseLimitPropertyName() {
        return INTERACTIVE_PROCESS_USE_LIMIT;
    }

    public String getPartialSaxReaderMBLimitPropertyName() {
        return PARTIALSAXREADER_LIMIT_MB_SETTING;
    }

    public String getDuplicated_Requeset_Suspension_In_secs() {
        return DUPLICATED_REQUEST_SUSPENSION_IN_SECS;
    }

    protected int getAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsAffineConnections"));
    }

    protected int getPeakAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsPeakAffineConnections"));
    }

    protected int getNonAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsNonAffineConnections"));
    }

    protected int getPeakNonAffineConnectionsProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsPeakNonAffineConnections"));
    }

    protected int getMaxProcessProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsMaximumProcesses"));
    }

    protected int getPeakMaxProcessProperty(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsPeakMaximumProcesses"));
    }

    protected int getQueueLimitTime(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsQueueLimit")) * 1000;
    }

    protected Date getDataSourceChange(Configuration configuration) throws ParseException {
        return dateFormat.parse(configuration.getValue("rsDataSourceChange"));
    }

    protected String getAuditLevel(Configuration configuration) {
        return configuration.getValue("rsAuditLevel");
    }

    protected boolean getAuditNativeQuery(Configuration configuration) {
        return Boolean.valueOf(configuration.getValue("rsAuditNativeQuery"));
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void initialize() {
        this.aProcessManager.setRequestReporter(this.queueableReportingHandler.getQueueableRequestReporter());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        String factoryClassName = this.getAttribute(log, "objectFactory");
        try {
            this.rsComponentFactory = (RSComponentFactory)Class.forName(factoryClassName).newInstance();
            this.rsComponentFactory.setHandler(this);
        }
        catch (Exception e) {
            log.fatalError("unable to instantiate object factory " + factoryClassName, e);
            throw new PogoException("unable to instantiate object factory " + factoryClassName, e);
        }
        this.executingRequests = this.rsComponentFactory.newInteractiveReportExecutingRequests();
        this.requestInvoker = this.createRequestInvoker();
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        try {
            this.requestInvoker.setCnRequestInfo(this.getAttribute(log, "cnRequestInfo"));
            this.requestInvoker.setCleanListName(this.getAttribute(log, "cn_cleanup_list"));
            this.aReportServerQueue = this.rsComponentFactory.newReportServerQueue();
            this.inProgressRequests = this.rsComponentFactory.newReportServerInProgressRequests();
            this.createAndRegisterInteractiveReportMonitor();
            this.usessl = PropertyInserter.getProperty("internalDispatcher.protocol").equalsIgnoreCase("https");
            if ("true".equals(this.getAttribute(log, "preventSSL"))) {
                this.usessl = false;
            }
            this.createProcessManager();
            this.retrieveRunTimeInfoReporter(engine);
            String prefix = this.getOptionalAttribute("errorMessageCodePrefix");
            if (prefix != null) {
                this.errorMessageCodePrefix = prefix;
            }
            log.debug("using error message code prefix: ", this.errorMessageCodePrefix);
            this.processMessageMappings();
            this.advancedSettingsConfigurationChange = this.rsComponentFactory.newAdvancedSettingsConfigurationChange();
            this.reportServerAttributeMonitor = this.rsComponentFactory.newReportServerAttributeMonitor(this.getConfig());
        }
        catch (Exception ex) {
            log.error("problem composing " + this.getName(), ex);
            throw new PogoException(DispatcherStrings.getInstance().getString(this.constructMessageID("badConfig")), ex);
        }
    }

    private void createProcessManager() {
        Element targetElement = this.getConfig().element("target");
        List elements = targetElement.elements("init-param");
        Map<String, String> initParamsMap = this.getInitParams(elements);
        ProcessExecutionMode processExecutionMode = new ProcessExecutionMode(initParamsMap, this.cclConfiguration);
        try {
            this.bibusThreads = Integer.parseInt(initParamsMap.get("threads"));
        }
        catch (NumberFormatException e) {
            this.bibusThreads = 10;
        }
        List childProcCmdList = targetElement.elements("child-proc-cmd");
        String[] args = this.getProcessArguments(childProcCmdList, initParamsMap, processExecutionMode);
        int reportServerPort = Integer.parseInt(initParamsMap.get("report_server_port"));
        String reportServerHost = "localhost";
        try {
            InetAddress inet = InetAddress.getLocalHost();
            reportServerHost = inet.getCanonicalHostName();
            log.debug("createProcessManager - reportServerHost = " + reportServerHost);
        }
        catch (UnknownHostException e) {
            log.error("Unable to resolve host name with UnknownHostException - " + e.getMessage());
            reportServerHost = "localhost";
        }
        if (reportServerPort > 0) {
            reportServerHost = initParamsMap.get("report_server_host");
        }
        String procManThreadName = this.getName() + "-ProcessManager";
        this.aProcessManager = this.rsComponentFactory.newProcessManager(procManThreadName, this.aReportServerQueue, args, targetElement, reportServerHost, reportServerPort, this.usessl);
        this.extractInitParams(initParamsMap, processExecutionMode);
    }

    private void extractInitParams(Map<String, String> initParamsMap, ProcessExecutionMode processExecutionMode) {
        try {
            this.aProcessManager.setMinProcessCount(Integer.parseInt(initParamsMap.get("linger_process")));
            this.aProcessManager.setMaxProcessCount(Integer.parseInt(initParamsMap.get("max_process")));
            try {
                this.aProcessManager.setDelinquenceLimit(Integer.parseInt(initParamsMap.get("delinquent_timeout_seconds")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int shutdownTimeLimit = this.getIntInitParam(initParamsMap, "process_shutdown_timeout_ms");
                this.aProcessManager.setShutdownTimeLimit(shutdownTimeLimit);
            }
            catch (NumberFormatException shutdownTimeLimit) {
                // empty catch block
            }
            try {
                int warmup = this.getIntInitParam(initParamsMap, "warmup");
                this.aProcessManager.setWarmup(warmup > 0);
            }
            catch (NumberFormatException warmup) {
                // empty catch block
            }
            try {
                int lightThreads = this.getIntInitParam(initParamsMap, "light_threads");
                this.aProcessManager.setLightThreads(lightThreads);
            }
            catch (NumberFormatException lightThreads) {
                // empty catch block
            }
            try {
                this.shutdownImmediateTimeLimit = Integer.parseInt(initParamsMap.get("process_shutdown_immediate_timeout_ms"));
            }
            catch (NumberFormatException lightThreads) {
                // empty catch block
            }
            int idle_process_check_interval_ms = Integer.parseInt(initParamsMap.get("idle_process_check_interval_ms"));
            int idle_process_max_idle_ticks = Integer.parseInt(initParamsMap.get("idle_process_max_idle_ticks"));
            String optionalMaxWaitParam = initParamsMap.get("max_wait_for_expired_process_to_become_idle_secs");
            long idle_max_wait = optionalMaxWaitParam != null ? (long)Integer.parseInt(optionalMaxWaitParam) : -1L;
            this.aProcessManager.setIdleProcessTimeout(idle_process_check_interval_ms, idle_process_max_idle_ticks, idle_max_wait);
            this.aProcessManager.setRequestCountLimit(Integer.parseInt(initParamsMap.get("default_process_use_limit")));
            this.aReportServerQueue.setProcessList(this.aProcessManager.getProcessList());
            this.setDefaultTimeout(Integer.parseInt(initParamsMap.get("queue_time_limit_ms")));
            this.requestInvoker.setReportServerPath(initParamsMap.get("worker_request_path"));
            log.debug("Current async_wait_timeout_ms value: ", this.requestExpirationTime);
            this.requestExpirationTime = Integer.parseInt(initParamsMap.get("async_wait_timeout_ms"));
            log.debug("async_wait_timeout_ms value from configuration file: ", this.requestExpirationTime);
            this.prestartProcess = Boolean.valueOf(initParamsMap.get("prestart_process"));
            String notificationTimeStr = initParamsMap.get("notificationTimeInterval");
            if (notificationTimeStr != null) {
                this.notificationTimeInterval = Integer.parseInt(notificationTimeStr) * 1000;
            }
            this.extractProcessCleanerInterval(initParamsMap);
            processExecutionMode.prepareWorkingDir(this.aProcessManager);
            processExecutionMode.prepareEnvironment(this.aProcessManager);
        }
        catch (Exception e) {
            log.error(DispatcherStrings.getInstance().getString(this.constructMessageID("badConfig")) + " while configuring " + this.getName(), e);
        }
    }

    private void retrieveRunTimeInfoReporter(PogoEngine engine) throws PogoException {
        String runTimeInfoReporter = this.getAttribute(log, "runTimeInfoReporter");
        this.queueableReportingHandler = (QueueableRequestReportingHandler)engine.lookupHandler(runTimeInfoReporter);
        if (this.queueableReportingHandler == null) {
            log.error("Lookup of reporting handler named \"", runTimeInfoReporter, "\" failed.");
        }
    }

    public void extractProcessCleanerInterval(Map<String, String> initParamsMap) {
        try {
            int processCleanerInterval = this.getIntInitParam(initParamsMap, "process_cleaner_interval");
            this.aProcessManager.setProcessCleanerInterval(processCleanerInterval);
        }
        catch (NumberFormatException e) {
            log.debug("process_cleaner_interval is invalid, default will be used.", e);
        }
    }

    private int getIntInitParam(Map<String, String> initParamsMap, String paramName) throws NumberFormatException {
        return Integer.parseInt(initParamsMap.get(paramName));
    }

    @Override
    public String constructMessageID(String msgTail) {
        String msgID = this.errorMessageCodePrefix + msgTail;
        log.debug("generated fault message ID: ", msgID);
        return msgID;
    }

    private void processMessageMappings() {
        log.debug("checking for a messageResourceMappings element.");
        Element messageMappingsElement = this.getConfig().element("messageResourceMappings");
        if (messageMappingsElement == null) {
            log.debug("no messageResourceMappings found.");
            return;
        }
        Iterator itMappingElems = messageMappingsElement.elementIterator("messageResourceMapping");
        while (itMappingElems.hasNext()) {
            String resourceBundle;
            Element messageMappingElement = (Element)itMappingElems.next();
            boolean ok = true;
            String msgPrefix = messageMappingElement.elementText("msgPrefix");
            if (msgPrefix == null || msgPrefix.length() == 0) {
                log.error("messageResourceMapping element is missing \"msgPrefix\" or it is empty.");
                ok = false;
            }
            if ((resourceBundle = messageMappingElement.elementText("resourceBundleName")) == null || resourceBundle.length() == 0) {
                log.error("messageResourceMapping element is missing \"resourceBundleName\" or it is empty.");
                ok = false;
            }
            if (ok) {
                log.debug("adding messageResourceMapping from prefix \"", msgPrefix, "\" to resource bundle \"", resourceBundle);
            }
            DispatcherStrings.getInstance().registerResourceBundle(msgPrefix, resourceBundle);
        }
    }

    private final RequestInvoker createRequestInvoker() {
        return this.rsComponentFactory.newRequestInvoker(this.executingRequests);
    }

    protected void setDispatcherGuid(String guid) {
        this.requestInvoker.setDispatcherGuid(guid);
    }

    @Override
    public void start() {
        this.inProgressRequests.startExpirationTimer(this.requestExpirationTime);
        this.aProcessManager.correctProcessBinaryPath(this.cclConfiguration);
        this.startMinimumProcesses();
        this.aProcessManager.start();
        this.temporaryObjectsControl.start();
    }

    private void startMinimumProcesses() {
        int minProcessCount = this.aProcessManager.getMinProcessCount();
        int maxProcessCount = this.aProcessManager.getMaxProcessCount();
        log.debug("minimum (linger) process count is: ", minProcessCount);
        log.debug("maximum process count is: ", maxProcessCount);
        minProcessCount = Math.min(minProcessCount, maxProcessCount);
        if (this.prestartProcess && minProcessCount > 0) {
            log.debug("prestarting ", minProcessCount, " processes.");
            this.aProcessManager.createAnotherProcess(minProcessCount);
        }
    }

    @Override
    public void stop() {
        if (this.aReportServerQueue != null) {
            this.aReportServerQueue.shutdown();
        }
        if (this.aProcessManager != null) {
            this.aProcessManager.shutdown();
        }
        if (this.inProgressRequests != null) {
            this.inProgressRequests.cancelExpirationTimer();
        }
        this.temporaryObjectsControl.stop();
    }

    public synchronized long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    protected synchronized void setDefaultTimeout(long newDefaultTimeout) {
        this.defaultTimeout = newDefaultTimeout;
        this.requestInvoker.setDefaultTimeout(newDefaultTimeout);
    }

    @Override
    public void suspend(boolean immediate) {
        if (!immediate) {
            return;
        }
        this.aProcessManager.suspend(immediate, this.shutdownImmediateTimeLimit);
        this.aReportServerQueue.suspend(immediate);
        this.inProgressRequests.clear();
    }

    private Element configureReportServerType(Element cclConfiguration) {
        if (cclConfiguration == null) {
            return cclConfiguration;
        }
        Element itemElement = cclConfiguration.addElement("item");
        Element reportServerTypeElement = itemElement.addElement("reportServerType");
        Element valueElement = reportServerTypeElement.addElement("value");
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        valueElement.setText(this.getReportServerType());
        return cclConfiguration;
    }

    String getReportServerType() {
        return REPORT_SERVER_MODE_INTERACTIVE;
    }

    @Override
    public void testFinishedStopping() {
        if (this.queueableReportingHandler == null) {
            return;
        }
        RequestReporter reporter = this.queueableReportingHandler.getRequestReporter();
        String state = reporter.getServiceStatus();
        if (state != "stopping") {
            return;
        }
        if (this.aReportServerQueue.getQueueSize() != 0) {
            return;
        }
        if (this.inProgressRequests.size() != 0) {
            return;
        }
        log.debug("service goes from \"STOPPING\" to \"SUSPENDED\"");
        reporter.setServiceStatus("suspended");
    }

    @Override
    public void resume() {
        this.startMinimumProcesses();
        this.aProcessManager.resumeIt();
        this.aReportServerQueue.resume();
    }

    @Override
    public ProcessManager getProcessManager() {
        return this.aProcessManager;
    }

    protected int getExecutionTimeLimit(Configuration configuration) throws NumberFormatException {
        return Integer.parseInt(configuration.getValue("rsExecutionTimeLimit"));
    }

    protected int getDuplicatedRequestSuspensionInSeconds() {
        return this.duplicatedRequestSuspensionInSeconds;
    }

    public long getRequestExpirationTime() {
        return this.requestExpirationTime;
    }

    private void createAndRegisterInteractiveReportMonitor() {
        if (!PogoMBeanServer.isNoJMX()) {
            this.createInteractiveReportMonitor();
            this.registerInteractiveReportMonitor();
        }
    }

    private final void createInteractiveReportMonitor() {
        InteractiveReportGeneralList queuedList = this.rsComponentFactory.newInteractiveReportGeneralList(this.aReportServerQueue);
        InteractiveReportGeneralList inProgressList = this.rsComponentFactory.newInteractiveReportGeneralList(this.inProgressRequests);
        this.interactiveReportMonitor = this.rsComponentFactory.newInteractiveReportMonitor(queuedList, inProgressList);
    }

    protected void registerInteractiveReportMonitor() {
        MBeanServer server = PogoMBeanServer.getInstance().getServer();
        try {
            server.registerMBean(this.interactiveReportMonitor, MBeanUtils.createObjectNameInstance("type=interactveReportMonitor,service=" + this.getServiceName()));
        }
        catch (JMException e) {
            log.error("Exception registering interactive requests MBean", e);
        }
    }

    private String getServiceName() {
        return REPORT_SERVICE_NAME;
    }

    @Override
    public int getRequestUsage() {
        return this.aProcessManager.getRequestUsage();
    }

    @Override
    public int getCurrentCapacity() {
        return -1;
    }

    @Override
    public ReportServerInProgressRequests getInProgressRequests() {
        return this.inProgressRequests;
    }

    public String getCleanListName() {
        return this.requestInvoker != null ? this.requestInvoker.getCleanListName() : null;
    }

    public String getCnRequestInfo() {
        return this.requestInvoker != null ? this.requestInvoker.getCnRequestInfo() : null;
    }

    public String getReportServerPath() {
        return this.requestInvoker != null ? this.requestInvoker.getReportServerPath() : null;
    }

    public String getRunTimeInfoReporter() {
        return this.queueableReportingHandler != null ? this.queueableReportingHandler.getName() : null;
    }

    public boolean getUseSSL() {
        return this.usessl;
    }

    public String getObjectFactoryName() {
        return this.rsComponentFactory != null ? this.rsComponentFactory.getClass().getName() : null;
    }

    public int getShutdownImmediateTimeLimit() {
        return this.shutdownImmediateTimeLimit;
    }

    public int getNrOfBibusThreads() {
        return this.bibusThreads;
    }

    public boolean willPrestartProcess() {
        return this.prestartProcess;
    }

    @Override
    public void notifyCmCacheStateChange(boolean isEnabled) {
        super.notifyCmCacheStateChange(isEnabled);
        this.expireAllReportServerProcesses();
    }

    private void expireAllReportServerProcesses() {
        if (this.aProcessManager != null) {
            this.aProcessManager.setConfigurationChanged();
            this.aProcessManager.useNewConfiguration();
        }
    }

    public boolean hasCclConfig() {
        return this.cclConfiguration != null;
    }

    @Override
    public BodyHandler createBodyHandler() {
        return new ReportServerBodyHandler();
    }
}

