/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.BIBusPassThroughCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.monitoring.RequestInfo;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.DispatcherTransportVars;
import com.cognos.pogo.pdk.common.Tracking;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.pdk.stax.StaxEnvelope;
import com.cognos.pogo.reportservice.BatchReportServerHandler;
import com.cognos.pogo.reportservice.CancelEnvelopeFactory;
import com.cognos.pogo.reportservice.ConnectionAssignmentInterlock;
import com.cognos.pogo.reportservice.NoConnectionException;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ProcessShutdownException;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerConnectionPool;
import com.cognos.pogo.reportservice.ReportServerHandler;
import com.cognos.pogo.reportservice.ReportServerInProgressRequests;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.reportservice.ReportServerRequestInformation;
import com.cognos.pogo.reportservice.ServiceStoppedException;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Element;

public class ReportServerRequest
implements Cleanable,
ReportServerRequestInformation {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String CONTINUE_WAIT_LOOP = "continueWaitLoop";
    private static final String SOAPACTION_HEADER_NAME = "SOAPAction";
    private static final String CANCEL_SOAP_ACTION = "http://developer.cognos.com/schemas/reportService/1.control";
    private static final List<InputStream> NO_ATTACHMENTS = Collections.emptyList();
    protected RSComponentFactory componentFactory;
    private ReportServerQueue reportServerQueue;
    protected ReportServerConnection connection;
    private String requestID;
    protected BIBusEnvelope requestEnvelope;
    private BIBusEnvelope responseEnvelope;
    protected InternetHeaders requestHeaders;
    private int processID;
    protected BIBusCommand command;
    protected String requestPath = "/warp";
    protected long lastAccessed;
    private boolean inUse = true;
    private RequestInfo requestInfo;
    private boolean recycleOnly;
    private boolean cancel;
    private boolean overrideStatus;
    private int partialSaxLimit = -1;
    private boolean shouldLimitLargeResponses;
    private long queueTimeout;
    private RequestAffinity affinity = RequestAffinity.NONE;
    private final long startTime;
    protected long timeWhenRequestWasSentToProcess;
    private boolean serviceStopped;
    private BatchReportServerHandler.ServiceCapacityCallback capacityConfiguration;
    protected InteractiveReportExecutingRequests executingRequests;
    protected ConnectionAssignmentInterlock connectionAssignmentInterlock;
    private Iterator<InputStream> requestAttachments = NO_ATTACHMENTS.iterator();
    private MessageContext mc = null;
    ReportServerHandler reportServerHandler = null;
    int maximuRetry = 0;
    int minRetry = 5;

    public ReportServerRequest(RSComponentFactory factory, BIBusEnvelope anEnvelope, InternetHeaders headers, ReportServerQueue queue, String dispatcherGuid, InteractiveReportExecutingRequests executingRequests) {
        this.componentFactory = factory;
        this.setRequestEnvelope(anEnvelope);
        this.requestHeaders = headers;
        this.reportServerQueue = queue;
        this.processID = anEnvelope.getConversationContextProcessID();
        this.executingRequests = executingRequests;
        String requestID = anEnvelope.getConversationContextID();
        if (requestID == null || requestID.length() == 0) {
            log.error("request does not have conversation context id.  This is wrong.  ", "Will use tracking/requestContext, but an affine request will likely fail.");
            requestID = anEnvelope.getTrackingRequestContext();
        }
        this.setRequestID(requestID);
        anEnvelope.setConversationContextNodeID(dispatcherGuid);
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void claimRequest(BIBusEnvelope envelope, InternetHeaders headers, String requestID) {
        this.inUse = true;
        this.setRequestEnvelope(envelope);
        this.setRequestHeaders(headers);
        this.copyRequestIDToEnvelope(requestID);
        this.setOverrideStatus(false);
        this.setServiceStopped(false);
    }

    void copyRequestIDToEnvelope(String requestID) {
        String currentId = this.requestEnvelope.getConversationContextID();
        if (currentId == null || currentId.length() == 0) {
            log.debug("copyRequestIDToEnvelope() setting conversationContext/id=", requestID);
            this.requestEnvelope.setConversationContextID(requestID);
        } else if (!currentId.equals(requestID)) {
            log.error("attempt to clobber conversationContext/id. current id=", currentId, ", new id =", requestID, ", preserving current id.");
        }
        this.requestEnvelope.setConversationContextStatus("");
    }

    public synchronized void setServerConnection(ServerConnection aConnection) {
        Check.assertTrue(this.connection == null, "A thread is assigning a connection to a ReportServerRequest that already has a connection!");
        this.connection = (ReportServerConnection)aConnection;
        this.processID = this.connection.getProcessID();
        this.connection.setOwnerRequest(this);
        this.adjustCapacity(-1);
    }

    public synchronized boolean hasServerConnection() {
        return this.connection != null;
    }

    public ReportServerConnection getServerConnection() {
        return this.connection;
    }

    @Override
    public String getRequestID() {
        return this.requestID;
    }

    public void setRequestID(String newRequestID) {
        this.requestID = newRequestID;
    }

    void setRequestEnvelope(BIBusEnvelope anEnvelope) {
        this.requestEnvelope = anEnvelope;
        this.requestEnvelope.removeDispatcherTransport(CONTINUE_WAIT_LOOP);
    }

    void setRequestHeaders(InternetHeaders headers) {
        this.requestHeaders = headers;
    }

    public synchronized void setAffinity(RequestAffinity requestAffinity, long defaultTimeout) {
        this.affinity = requestAffinity;
        if (this.affinity == RequestAffinity.NONE) {
            this.queueTimeout = defaultTimeout;
            return;
        }
        this.queueTimeout = this.requestEnvelope.getConversationContextAffinityStrength();
        if (this.queueTimeout <= 0L) {
            log.debug("affine request contains invalid (<=0) affinity strength.");
            this.queueTimeout = defaultTimeout;
        }
    }

    synchronized RequestAffinity getAffinity() {
        return this.affinity;
    }

    @Override
    public int getProcessID() {
        return this.processID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clean(MessageContext mc) {
        if (this.hasServerConnection()) {
            if (this.recycleOnly) {
                log.debug(this, ".clean() called.  Recycling connection ", this.connection);
                this.connection.reinitialize();
                this.recycleOnly = false;
            } else {
                log.debug(this, ".clean() called.  Releasing connection ", this.connection);
                this.connection.release();
                this.adjustCapacity(1);
                this.connection = null;
            }
        } else {
            log.debug(this, ".clean() called but it does not have a connection");
        }
        ReportServerRequest reportServerRequest = this;
        synchronized (reportServerRequest) {
            this.inUse = false;
        }
    }

    protected BIBusPassThroughCommand createCommandToCommWithService(BIBusEnvelope requestEnvelope, InternetHeaders requestHeaders, ServerConnection connection) {
        return this.componentFactory.createCommandToCommWithService(requestEnvelope, requestHeaders, connection);
    }

    public void sendRequest() throws CommandExecutionException, NoConnectionException, NoSuchObjectException, ServiceStoppedException, ProcessShutdownException {
        this.reportServerHandler = this.getServerHandler();
        ArrayList<Integer> processIDList = new ArrayList<Integer>();
        if (this.reportServerHandler != null) {
            this.maximuRetry = this.reportServerHandler.getDuplicatedRequestSuspensionInSeconds();
            if (this.maximuRetry >= this.minRetry) {
                ProcessList processList = this.reportServerHandler.getProcessManager().getProcessList();
                for (ProcessFacade facade : processList.getProcesListView()) {
                    if (this.getProcessID() == facade.getProcessID()) continue;
                    processIDList.add(facade.getProcessID());
                }
            }
            log.debug("processIDList.size:" + processIDList.size());
        }
        int tries = 0;
        boolean processSuccessful = false;
        boolean continueLoop = true;
        do {
            try {
                log.debug("send request at tries number:: " + tries);
                this.sendRequestInternal();
                processSuccessful = true;
                continueLoop = false;
                log.debug("successful complete");
            }
            catch (DuplicatedRequestException e) {
                if (processIDList.size() > 0 && tries < processIDList.size()) {
                    log.debug("Request jammed in the current PID " + this.getProcessID() + " retry at process " + processIDList.get(tries) + "at try number:" + String.valueOf(tries));
                    this.processID = (Integer)processIDList.get(tries);
                    this.connection = null;
                    ++tries;
                    continue;
                }
                continueLoop = false;
            }
        } while (continueLoop);
        if (processSuccessful) {
            log.debug("Successful complete and out of loop");
        } else {
            log.error("Failed the retry with fail over");
        }
    }

    private void sendRequestInternal() throws CommandExecutionException, NoConnectionException, NoSuchObjectException, ServiceStoppedException, ProcessShutdownException, DuplicatedRequestException {
        this.getConnection();
        this.requestEnvelope.setConversationContextProcessID(this.getProcessID());
        if (this.connectionAssignmentInterlock != null && !this.connectionAssignmentInterlock.setProcessID(this.getProcessID())) {
            log.debug("request cancelled before connection was assigned. ", "Don't send the request, and release the connection");
            this.connection.release();
            this.connection = null;
            return;
        }
        BIBusPassThroughCommand passThroughCommand = this.createCommandToCommWithService(this.requestEnvelope, this.requestHeaders, this.connection);
        passThroughCommand.setAutoRelease(false);
        passThroughCommand.setRequestContext(this.requestPath);
        this.command = passThroughCommand;
        if (this.shouldLimitLargeResponses) {
            this.command.setLargeResponseHint(this.partialSaxLimit);
        } else {
            this.command.clearLargeResponseHint();
        }
        this.timeWhenRequestWasSentToProcess = System.currentTimeMillis();
        this.addRequestAttachments();
        this.addToExecutingList();
        try {
            this.command.execute();
        }
        finally {
            this.removeFromExecutingList();
        }
        this.updatePerformanceIndicator();
        this.getRequestInfo().setProcessTime(System.currentTimeMillis() - this.timeWhenRequestWasSentToProcess);
        this.lastAccessed = System.currentTimeMillis();
    }

    protected void updatePerformanceIndicator() {
        PerformanceEventListener pi = PerformanceIndicator.getListener();
        if (pi.isEnabled()) {
            this.updateObjectPath(pi);
            this.updateProcessInfo(pi);
        }
    }

    private void updateObjectPath(PerformanceEventListener pi) {
        String reportPath = this.getReportPath();
        if (StringUtils.isNotEmpty(reportPath)) {
            pi.handleObjectPath(reportPath);
        }
    }

    private void updateProcessInfo(PerformanceEventListener pi) {
        pi.handleProcessInfo(this.getProcessID(), this.getProcessName());
    }

    private String getProcessName() {
        return this.connection != null ? this.connection.getProcessName() : null;
    }

    public void setRequestAttachments(MessageContext mc) {
        Iterator attachments = (Iterator)mc.getProperty("request.attachments");
        if (attachments != null && attachments.hasNext()) {
            log.debug("Setting request attachments");
            this.requestAttachments = attachments;
        }
    }

    protected void addRequestAttachments() {
        if (this.requestAttachments.hasNext()) {
            log.debug("Adding request attachments to BIBusPassThroughCommand");
            this.command.setRequestAttachments(this.requestAttachments);
        }
    }

    protected void addToExecutingList() throws DuplicatedRequestException {
        if (this.connection != null) {
            this.checkPreviousConversation();
        }
    }

    protected void removeFromExecutingList() {
        if (this.connection != null) {
            this.connection.setSigature(null);
        }
    }

    private void checkPreviousConversation() throws DuplicatedRequestException {
        if (this.reportServerHandler == null) {
            log.debug("Report Handler is null");
            return;
        }
        if (this.reportServerHandler != null && this.maximuRetry >= this.minRetry) {
            ProcessList processList = this.reportServerHandler.getProcessManager().getProcessList();
            String sig = this.connection.getProcessID() + "-" + this.getRequestID() + "-" + this.getPassportID();
            String logstr = this.connection.getProcessID() + "-" + this.getRequestID() + "-" + this.getPassportID() + "-" + this.getRequestEnvelope().getBiBusHeader().getTracking().getRequestContext();
            if (!this.asyncCheck(this.reportServerHandler, this.maximuRetry, logstr)) {
                this.syncCheck(this.maximuRetry, processList, sig, logstr);
            }
        }
    }

    private boolean asyncCheck(ReportServerHandler reportServerHandler, int maximuRetry, String sig) throws DuplicatedRequestException {
        int attempts;
        for (attempts = 0; this.checkInProgressMap(reportServerHandler) && attempts < maximuRetry; ++attempts) {
            if (this.isWaitRequest()) break;
            this.pauseOneSeconds(sig, attempts, "async pool", maximuRetry);
        }
        boolean ret = false;
        if (attempts >= maximuRetry) {
            ret = true;
            log.debug("Abandon async after maximum delay exceeded\n");
            throw new DuplicatedRequestException("Abandon async after maximum delay exceeded");
        }
        if (attempts > 0) {
            log.debug("Async waited succeeded at " + String.valueOf(attempts) + " attempts\n");
            ret = true;
        } else if (attempts == 0) {
            log.debug("Not in async pool\n");
        }
        return ret;
    }

    private void syncCheck(int maximuRetry, ProcessList processList, String sig, String log2) throws DuplicatedRequestException {
        int attempts = 0;
        boolean found = false;
        for (ProcessFacade facade : processList.getProcesListView()) {
            if (facade.getProcessID() != this.connection.getProcessID()) continue;
            if (this.isWaitRequest()) break;
            boolean inUse = false;
            for (attempts = 0; attempts < maximuRetry; ++attempts) {
                inUse = this.requestAlreadyInProcessFacade(facade, sig);
                if (!inUse) break;
                found = true;
                this.pauseOneSeconds(log2, attempts, "sync pool", maximuRetry);
            }
            this.connection.setSigature(sig);
            if (!inUse || attempts < maximuRetry) continue;
            log.debug("Abandon sync after maximum delay exceeded\n");
            throw new DuplicatedRequestException("Abandon sync after maximum delay exceeded");
        }
        if (!this.inUse && found) {
            log.debug("Sync delay succeeded at " + attempts + " attempts\n");
        }
    }

    private void pauseOneSeconds(String sig, int attempts, String str, int maximuRetry) {
        try {
            String temp = "Sleep 1 second in " + str + " with try at: " + String.valueOf(attempts) + " sig=" + sig + " with maximuRetry=" + maximuRetry + "\n";
            log.debug(temp);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean checkInProgressMap(ReportServerHandler reportServerHandler) {
        boolean ret = false;
        ReportServerInProgressRequests inprogressRequests = reportServerHandler.getInProgressRequests();
        ReportServerRequest inprogressRequest = inprogressRequests.getRequestFromInProgressMap(this.getRequestID());
        if (inprogressRequest != null && this.connection.getProcessID() == inprogressRequest.getProcessID() && this.getPassportID().equalsIgnoreCase(inprogressRequest.getPassportID())) {
            log.debug("Found in async progress map" + this.connection.getProcessID() + "-" + this.getRequestID() + "-" + this.getPassportID() + "\n");
            ret = true;
        }
        return ret;
    }

    private boolean isWaitRequest() {
        Element operation;
        boolean ret = false;
        Element body = this.requestEnvelope.getBody();
        List content = body.content();
        if (content.size() > 0 && "wait".equalsIgnoreCase((operation = (Element)content.get(0)).getName())) {
            ret = true;
        }
        return ret;
    }

    private boolean requestAlreadyInProcessFacade(ProcessFacade facade, String sig) {
        boolean ret = false;
        ReportServerConnectionPool noneAffinePool = facade.getNoneAffinePool();
        Set<ServerConnection> noneAfineViews = noneAffinePool.getConnectionsView();
        for (ServerConnection con : noneAfineViews) {
            String signature = con.getSigature();
            if (signature == null || !signature.equalsIgnoreCase(sig)) continue;
            ret = true;
            break;
        }
        if (!ret) {
            ReportServerConnectionPool affinePool = facade.getAffinePool();
            Set<ServerConnection> afineViews = affinePool.getConnectionsView();
            for (ServerConnection con : afineViews) {
                String signature = con.getSigature();
                if (signature == null || !signature.equalsIgnoreCase(sig)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    protected void getConnection() throws NoConnectionException, NoSuchObjectException, ServiceStoppedException, ProcessShutdownException {
        if (!this.hasServerConnection()) {
            log.debug(this, " does not have a connection.  Attempting to get one.");
            this.reportServerQueue.getConnection(this, this.queueTimeout);
            if (this.isServiceStopped()) {
                throw new ServiceStoppedException();
            }
            if (!this.hasServerConnection()) {
                log.info(this, ".sendRequest() failed.  No connection was available even after queuing.");
                throw new NoConnectionException();
            }
            if (this.connection.isDisposed()) {
                log.debug(this, ".sendRequest() failed.  Connection has been disposed.");
                throw new ProcessShutdownException();
            }
        }
    }

    public boolean saveResponse(MessageContext aMessageContext) {
        BIBusEnvelope response = this.getResponseEnvelope();
        if (response == null) {
            return false;
        }
        String requestRequestContext = this.requestEnvelope.getRequestContext();
        if (!requestRequestContext.equals(response.getRequestContext())) {
            this.connection.setBadInputStream();
            log.debug("The 'requestContext' in the response does not match the request, or does not exist. ", "The mismatched response: ", response);
        }
        this.setResponseEnvelope(response);
        String cc = this.getResponseConversationContextID();
        this.setRequestID(cc);
        this.copyResponseToMessageContextProperty(aMessageContext, response);
        return true;
    }

    void setResponseEnvelope(BIBusEnvelope response) {
        this.responseEnvelope = response;
    }

    protected String getResponseConversationContextID() {
        return this.responseEnvelope.getConversationContextID();
    }

    protected void copyResponseToMessageContextProperty(MessageContext aMessageContext, BIBusEnvelope response) {
        aMessageContext.setResponseName("response");
        aMessageContext.setProperty("response.envelope", response);
        aMessageContext.setProperty("response.headers", this.getResponseMIMEHeaders());
        aMessageContext.setProperty("response.status_code", Integer.toString(this.getStatusCode()));
        aMessageContext.setProperty("response.status_msg", this.getStatusString());
        Iterator<?> attachments = this.getAttachments();
        if (attachments.hasNext()) {
            aMessageContext.setProperty("response.attachments", attachments);
            aMessageContext.setProperty("response.boundary", StringUtils.getUniqueValue());
        }
    }

    public boolean receivedResponse() {
        if (this.command == null) {
            return false;
        }
        return this.command.isResponseReceived();
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.command.getResponseEnvelope();
    }

    protected InternetHeaders getResponseMIMEHeaders() {
        return this.command.getResponseMIMEHeaders();
    }

    protected int getStatusCode() {
        return this.command.getStatusCode();
    }

    protected String getStatusString() {
        return this.command.getStatusString();
    }

    protected Iterator<?> getAttachments() {
        return this.command.getAttachments();
    }

    public void setRequestPath(String path) {
        this.requestPath = path;
    }

    public boolean isInProgress() {
        if (this.isOverrideStatus()) {
            return false;
        }
        String status = this.responseEnvelope.getConversationContextStatus();
        if (status == null || "".equals(status)) {
            return false;
        }
        if ("complete".equals(status) || "prompting".equals(status) || "conversationComplete".equals(status)) {
            String sContinueWaitLoop = this.responseEnvelope.getDispatcherTransportValue(CONTINUE_WAIT_LOOP);
            if ("true".equals(sContinueWaitLoop)) {
                log.debug("isInProgress() returns true: response status is [", status, "] but continueWaitLoop is true.");
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(ProcessList processList) {
        this.cancel = true;
        BIBusEnvelope cancelEnvelope = this.createCancelEnvelope();
        ReportServerConnection aServerConnection = null;
        try {
            aServerConnection = processList.getAffineConnection(this.getProcessID(), RequestAffinity.CONTROL);
            aServerConnection.setRequestHeader(SOAPACTION_HEADER_NAME, CANCEL_SOAP_ACTION);
            aServerConnection.setRequestBodySource(new CancelMsgSource(cancelEnvelope));
            aServerConnection.sendRequest(this.requestPath);
            InputStream responseStream = aServerConnection.getInputStream();
            int bytesRead = -1;
            if (log.isDebugEnabled()) {
                BIBusEnvelope cancelResponseEnvelope = new BIBusEnvelope(responseStream);
                log.debug("Cancel response from Report Server:");
                log.debug(cancelResponseEnvelope);
            } else {
                byte[] buffer = new byte[8192];
                bytesRead = responseStream.read(buffer);
                while (bytesRead != -1) {
                    bytesRead = responseStream.read(buffer);
                }
            }
        }
        catch (Exception ex) {
            log.debug("Attempt to cancel a timed-out async request failed... releasing resources anyway", ex);
        }
        finally {
            if (aServerConnection != null) {
                aServerConnection.release();
            }
            this.setRecycleOnly(false);
            this.clean(null);
            this.cancel = false;
        }
        this.lastAccessed = System.currentTimeMillis();
    }

    private BIBusEnvelope createCancelEnvelope() {
        return CancelEnvelopeFactory.createCancelEnvelope(this.responseEnvelope, log);
    }

    public boolean isExpired(long expirationTime) {
        if (this.isInUse()) {
            return false;
        }
        return System.currentTimeMillis() - this.lastAccessed > expirationTime;
    }

    public synchronized boolean isInUse() {
        return this.inUse;
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public void setRequestInfo(RequestInfo info) {
        this.requestInfo = info;
    }

    public String toString() {
        Tracking tracking = this.requestEnvelope.getBiBusHeader().getTracking();
        String primaryID = tracking.getRequestContext();
        DispatcherTransportVars dispatcherTransportVars = this.requestEnvelope.getBiBusHeader().getDispatcherTransportVars();
        String originalSOAPAction = dispatcherTransportVars.getValue("originalSOAPAction");
        if (originalSOAPAction == null) {
            String[] headers = this.requestHeaders.getHeader(SOAPACTION_HEADER_NAME);
            originalSOAPAction = headers != null && headers.length > 0 && headers[0] != null ? headers[0] : "n/a";
        }
        StringBuffer strbuf = new StringBuffer("ReportServerRequest Primary ID: ");
        strbuf.append(primaryID);
        strbuf.append(", ");
        strbuf.append("Secondary ID: ");
        strbuf.append(this.getRequestID());
        strbuf.append(", Original SOAPAction: ");
        strbuf.append(originalSOAPAction);
        strbuf.append(" - \"");
        try {
            if (this.requestEnvelope instanceof StaxEnvelope) {
                strbuf.append(this.requestEnvelope.getBodyHandler().getMethodName());
            } else {
                Element operation = (Element)this.requestEnvelope.getBody().elementIterator().next();
                strbuf.append(operation.getName());
            }
        }
        catch (Exception x) {
            strbuf.append("unknown operation");
        }
        strbuf.append("\" (");
        strbuf.append(this.affinity.toString());
        strbuf.append(")");
        return strbuf.toString();
    }

    public void setRecycleOnly(boolean b) {
        this.recycleOnly = b;
    }

    boolean isOverrideStatus() {
        return this.overrideStatus;
    }

    public void setOverrideStatus(boolean overrideStatus) {
        this.overrideStatus = overrideStatus;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean requestLimitReached(int executionTimeLimit) {
        if (executionTimeLimit == 0) {
            log.debug("Execution time limit not set.  No limits are imposed.");
            return false;
        }
        return System.currentTimeMillis() - this.getStartTime() > (long)executionTimeLimit;
    }

    @Override
    public String getPassportID() {
        return this.requestEnvelope.getPassportID();
    }

    protected boolean isServiceStopped() {
        return this.serviceStopped;
    }

    protected void setServiceStopped(boolean serviceStopped) {
        this.serviceStopped = serviceStopped;
    }

    @Override
    public long getStartedExecutingTime() {
        return this.timeWhenRequestWasSentToProcess;
    }

    @Override
    public String getReportPath() {
        BodyHandler bodyHandler = this.requestEnvelope.getBodyHandler();
        String path = bodyHandler.getReportPath();
        if (path == null && this.responseEnvelope != null) {
            path = this.responseEnvelope.getBodyHandler().getReportPath();
        }
        return path;
    }

    protected BIBusCommand getBIBusPassThroughCommand() {
        return this.command;
    }

    public void setCapacityConfiguration(BatchReportServerHandler.ServiceCapacityCallback scc) {
        this.capacityConfiguration = scc;
    }

    private void adjustCapacity(int change) {
        if (this.capacityConfiguration != null && this.affinity == RequestAffinity.NONE) {
            this.capacityConfiguration.adjustCapacity(change);
        }
    }

    public void setConnectionAssignmentInterlock(ConnectionAssignmentInterlock connectionAssignmentInterlock) {
        this.connectionAssignmentInterlock = connectionAssignmentInterlock;
    }

    public void setBIBusPassThroughCommand(BIBusPassThroughCommand command) {
        this.command = command;
    }

    @Override
    public Element getRequestBody() {
        return this.requestEnvelope.getBody();
    }

    public BIBusEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    public void setPartialSaxLimitInput(int newPartialSaxLimit) {
        if (newPartialSaxLimit != this.partialSaxLimit) {
            this.partialSaxLimit = newPartialSaxLimit;
        }
        this.shouldLimitLargeResponses = this.partialSaxLimit != -1;
    }

    public boolean isNonQueueable() {
        String noQueueing = this.getRequestEnvelope().getBiBusHeader().getDispatcherTransportVars().getValue("NoQueueing");
        return "true".equalsIgnoreCase(noQueueing);
    }

    public MessageContext getMc() {
        return this.mc;
    }

    public void setMc(MessageContext mc) {
        this.mc = mc;
    }

    protected ReportServerHandler getServerHandler() {
        Object handler;
        if (this.mc != null && (handler = this.mc.getProperty("envelope.bodyHandlerFactory")) instanceof ReportServerHandler) {
            return (ReportServerHandler)handler;
        }
        return null;
    }

    private class CancelMsgSource
    implements MsgBodyGenerator {
        BIBusEnvelope cancelEnvelope;

        CancelMsgSource(BIBusEnvelope cancelEnvelope) {
            this.cancelEnvelope = cancelEnvelope;
        }

        @Override
        public void writeBody(OutputStream outStream) throws IOException {
            this.cancelEnvelope.writeAsXML(outStream);
            outStream.flush();
        }

        @Override
        public boolean rewind() {
            return true;
        }
    }

    public class DuplicatedRequestException
    extends Exception {
        private String message;

        public DuplicatedRequestException(String message) {
            this.message = message;
        }
    }
}

