/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice.util;

import com.cognos.pogo.reportservice.util.ReportServerProcessCommands;
import com.cognos.pogo.reportservice.util.UnixPingCommand;
import com.cognos.pogo.reportservice.util.WindowsPingCommand;

public abstract class PingCommand {
    protected PingCommand() {
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    public boolean pingProcess(int processID) {
        String command = this.getCommand(processID);
        String[] consoleOutput = ReportServerProcessCommands.runCommandConsole(command);
        return this.isProcessAlive(consoleOutput, processID);
    }

    protected abstract boolean isProcessAlive(String[] var1, int var2);

    protected abstract String getCommand(int var1);

    public static PingCommand createPingCommand() {
        if (PingCommand.isWindowsOS()) {
            return new WindowsPingCommand();
        }
        return new UnixPingCommand();
    }

    abstract int getAlwaysPingable();

    abstract int getNeverPingable();
}

