/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.ConfigurationDynamic;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.DefaultService;
import javax.management.MBeanServer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMXConfigurableService
extends DefaultService {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(JMXConfigurableService.class.getName());
    private ConfigurationDynamic configurationMBean;
    private Configuration savedConfiguration;

    @Override
    public void initialize() {
        if (this.getAttributeList().size() > 0) {
            this.createServiceMBean();
        }
    }

    private void createServiceMBean() {
        MBeanServer server = PogoMBeanServer.getInstance().getServer();
        try {
            String property = PropertyInserter.getProperty("allowJMXConfiguration", "false");
            boolean allowJMXConfiguration = Boolean.valueOf(property);
            if (allowJMXConfiguration) {
                this.configurationMBean = new ConfigurationDynamic(this, this.savedConfiguration);
                this.configurationMBean.setConfiguration(this.savedConfiguration);
                server.registerMBean(this.configurationMBean, MBeanUtils.getObjectName(this.serviceName));
            }
        }
        catch (Exception e) {
            cat.error("unable to create configuration MBean", (Throwable)e);
        }
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.savedConfiguration = configuration;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.setConfiguration(configuration);
    }

    private void setConfiguration(Configuration configuration) {
        if (this.configurationMBean != null) {
            this.configurationMBean.setConfiguration(configuration);
        }
    }
}

