/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.impl.PogoEngineImpl;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.services.DefaultHandlerService;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class RootHandlerService
extends DefaultHandlerService {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RootHandlerService.class.getName());
    private String rootHandlerName = null;

    @Override
    public HandlerPool contextualize(Element element) throws InvalidServiceException {
        HandlerPool handlerPool = super.contextualize(element);
        Element engineElem = (Element)element.selectSingleNode("engine");
        this.rootHandlerName = engineElem.attributeValue("root_handler");
        return handlerPool;
    }

    @Override
    public void compose(PogoEngine manager) {
        super.compose(manager);
        Handler handler = this.engine.getHandlerPool().find(this.rootHandlerName);
        if (handler == null) {
            cat.fatalError("Root handler named: \"" + this.rootHandlerName + "\" is unknown.");
        } else {
            ((PogoEngineImpl)manager).setRootHandler(handler);
        }
    }
}

