/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.DefaultService;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.util.threads.SafeThread;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Random;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.oro.io.Perl5FilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.dom4j.Element;

public class TempFileCleanupService
extends DefaultService {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(TempFileCleanupService.class.getName());
    CleanerRunnable worker;
    Thread worker_thread;
    private HashMap<String, String> initParamsMap = new HashMap();

    @Override
    public HandlerPool contextualize(Element element) throws InvalidServiceException {
        this.getInitParams(element);
        return super.contextualize(element);
    }

    private void getInitParams(Element element) {
        for (Element param : element.selectNodes("//init-param")) {
            this.initParamsMap.put(param.elementTextTrim("param-name"), param.elementTextTrim("param-value"));
        }
    }

    @Override
    public void start() {
        File f;
        int age_limit_ms = 1800000;
        int interval_ms = 10000;
        String path = this.getInitParameter("path");
        if (path == null || path.length() == 0) {
            cat.error(DispatcherStrings.getInstance().getString("missingPath"));
        }
        if (!(f = new File(path)).exists()) {
            cat.warn(DispatcherStrings.getInstance().getString("badPath"));
        }
        String sregex = this.getInitParameter("regex");
        String s = this.getInitParameter("case_sensitive");
        boolean case_sensitive = s != null && s.equals("true");
        s = this.getInitParameter("age_limit_s");
        if (s != null) {
            age_limit_ms = Integer.parseInt(s);
            age_limit_ms *= 1000;
        }
        if ((s = this.getInitParameter("interval_s")) != null) {
            interval_ms = Integer.parseInt(s);
            interval_ms *= 1000;
        }
        s = this.getInitParameter("priority_adjust");
        int priority_adjust = 0;
        if (s != null) {
            priority_adjust = Integer.parseInt(s);
        }
        this.worker = new CleanerRunnable(path, age_limit_ms, interval_ms, sregex, case_sensitive);
        this.worker_thread = new SafeThread(this.worker);
        this.worker_thread.setDaemon(true);
        this.worker_thread.setPriority(this.worker_thread.getPriority() + priority_adjust);
        this.worker_thread.start();
    }

    private String getInitParameter(String name) {
        return this.initParamsMap.get(name);
    }

    @Override
    public void stop() {
        if (this.worker == null) {
            return;
        }
        this.worker.stop();
        try {
            if (this.worker_thread == null) {
                return;
            }
            this.worker_thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class CleanerRunnable
    implements Runnable {
        File dir;
        int interval;
        CleanFileFilter filter = null;
        volatile boolean running = false;
        volatile Thread currentThread;

        CleanerRunnable(String path, int age_limit, int interval, String regex_string, boolean case_sensitive) {
            this.dir = new File(path);
            this.interval = interval;
            this.filter = new CleanFileFilter(regex_string, age_limit, case_sensitive);
        }

        public void stop() {
            this.running = false;
            this.currentThread.interrupt();
        }

        @Override
        public void run() {
            this.running = true;
            this.currentThread = Thread.currentThread();
            try {
                Thread.sleep(new Random(this.hashCode()).nextInt(this.interval));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.running) {
                this.filter.setCurrentTime();
                this.dir.listFiles(this.filter);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class CleanFileFilter
    implements FilenameFilter {
        Perl5FilenameFilter regex_filter = null;
        long current_time_ms;
        int age_limit;

        CleanFileFilter(String sregex, int age_limit, boolean case_sensitive) {
            int options = 16;
            if (!case_sensitive) {
                options |= 1;
            }
            try {
                this.regex_filter = new Perl5FilenameFilter();
                this.regex_filter.setFilterExpression(sregex, options);
            }
            catch (MalformedCachePatternException x) {
                cat.error(DispatcherStrings.getInstance().getString("badExpression") + x.getMessage());
            }
            this.age_limit = age_limit;
        }

        void setCurrentTime() {
            this.current_time_ms = System.currentTimeMillis();
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.regex_filter == null || !this.regex_filter.accept(dir, name)) {
                return false;
            }
            File f = new File(dir, name);
            if (this.current_time_ms - f.lastModified() > (long)this.age_limit) {
                if (cat.isDebugEnabled()) {
                    cat.debug("delete file: " + name);
                }
                f.delete();
            }
            return false;
        }
    }
}

