/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.contentmanager.service.ContentManagerAddService;
import com.cognos.pogo.contentmanager.service.ContentManagerDeleteService;
import com.cognos.pogo.monitoring.jmx.DispatcherUpdatesNotifier;
import com.cognos.pogo.monitoring.jmx.proxy.ConsolidatedMBeanCreator;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerFactory;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanRemover;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.services.SoapActionHandlerService;
import com.cognos.pogo.util.PogoLogger;

public class TransientSoapActionHandlerService
extends SoapActionHandlerService {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int INITIAL_LOAD_PRIORITY = 0;
    private PogoEngine pogoEngine;
    private Configuration configuration;
    private final PogoMBeanRemover pogoMBeanRemover;
    private boolean metricsExist;

    public TransientSoapActionHandlerService() {
        this(new PogoMBeanRemover());
    }

    public TransientSoapActionHandlerService(PogoMBeanRemover pogoMBeanRemover) {
        this.pogoMBeanRemover = pogoMBeanRemover;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.maybeCreateMBeans();
    }

    void maybeCreateMBeans() {
        this.metricsExist = this.pogoMBeanRemover.metricsExist();
        if (this.metricsExist) {
            this.recreateMBeans();
        }
    }

    @Override
    public void start() {
        log.debug("Starting TransientSoapActionHandlerService");
        this.maybeRegisterInCM();
        super.start();
        if (this.metricsExist) {
            this.notifyOtherDispatchers();
        }
    }

    private void recreateMBeans() {
        log.debug("Recreating MBeans for transient aoap action");
        this.removePreviousMBeans();
        ConsolidatedMBeanCreator beanCreator = this.getBeanCreator();
        beanCreator.createConsolidatedMBeans();
    }

    protected ConsolidatedMBeanCreator getBeanCreator() {
        ThresholdManager thresholdManager = ThresholdManagerFactory.getThresholdManager();
        String localSearchPath = this.configuration.getLocalSearchPath();
        return new ConsolidatedMBeanCreator(thresholdManager, localSearchPath);
    }

    private void notifyOtherDispatchers() {
        DispatcherUpdatesNotifier dispatcherUpdatesNotifier = new DispatcherUpdatesNotifier();
        DispatcherList dispatcherList = (DispatcherList)this.configuration.getDispatcherList();
        dispatcherUpdatesNotifier.notifyDispatchers(dispatcherList);
    }

    private void removePreviousMBeans() {
        this.pogoMBeanRemover.removeMetrics();
    }

    private void maybeRegisterInCM() {
        if (this.isRegisterInCM() && this.cmIsAvailable()) {
            this.registerInCM();
        }
    }

    private boolean cmIsAvailable() {
        return NodeIdGuidMapper.getContentManagerNID() != null;
    }

    private void registerInCM() {
        ContentManagerAddService addService = this.createContentManagerAddService();
        addService.setDispatcherPath(this.getDispatcherPath());
        addService.execute();
    }

    protected ContentManagerAddService createContentManagerAddService() {
        return new ContentManagerAddService(this);
    }

    @Override
    public void stop() {
        log.debug("Stopping TransientSoapActionHandlerService");
        super.stop();
        this.removeSoapActions();
        this.maybeUnregisterFromCM();
    }

    private void removeSoapActions() {
        for (String soapAction : this.soapActionList.keySet()) {
            this.pogoEngine.getDispatcherServices().removeSoapAction(soapAction);
        }
    }

    @Override
    public void compose(PogoEngine pogoEngine) {
        super.compose(pogoEngine);
        this.pogoEngine = pogoEngine;
    }

    @Override
    public void configure(Configuration configuration) {
        this.configuration = configuration;
        super.configure(configuration);
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configuration = configuration;
        super.reconfigure(configuration);
    }

    private void maybeUnregisterFromCM() {
        if (this.isRegisterInCM()) {
            this.unregisterFromCM();
        }
    }

    private void unregisterFromCM() {
        ContentManagerDeleteService deleteService = this.createContentManagerDeleteService();
        deleteService.setDispatcherPath(this.getDispatcherPath());
        deleteService.execute();
    }

    protected ContentManagerDeleteService createContentManagerDeleteService() {
        return new ContentManagerDeleteService(this.getName());
    }

    private String getDispatcherPath() {
        return (String)this.engine.getContextAttribute("com.ibm.cognos.pogo.dispatcher.path");
    }

    @Override
    public int getLoadPriority() {
        return 0;
    }
}

