/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services.concurrent;

import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.concurrent.ServiceExecutor;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ServiceOrderedMap {
    private static final PogoLogger cat = PogoLogger.getLoggerFor(ServiceOrderedMap.class.getName());
    private TreeMap<Integer, HashSet<ServiceExecutor>> orderedMap = new TreeMap();
    private List<Service> flattenedList;
    private ExecutorService execService = Executors.newCachedThreadPool();

    public void add(Integer order, Service service) {
        HashSet<ServiceExecutor> serviceSet = this.orderedMap.get(order);
        if (serviceSet == null) {
            serviceSet = new HashSet();
            this.orderedMap.put(order, serviceSet);
        }
        serviceSet.add(new ServiceExecutor(service));
        this.flattenedList = null;
    }

    public List<Service> getList() {
        if (this.flattenedList == null) {
            this.flattenedList = new ArrayList<Service>();
            for (HashSet<ServiceExecutor> serviceSet : this.orderedMap.values()) {
                for (ServiceExecutor serviceExecutor : serviceSet) {
                    this.flattenedList.add(serviceExecutor.getService());
                }
            }
        }
        return this.flattenedList;
    }

    public void run(ServiceExecutor.OperationType operation, Configuration configuration) {
        for (Map.Entry<Integer, HashSet<ServiceExecutor>> entry : this.orderedMap.entrySet()) {
            if (!operation.always() && entry.getKey() <= 0) continue;
            cat.info(operation.getVerb(), " services with priority ", entry.getKey());
            this.saveForTests(entry.getKey(), entry.getValue());
            HashSet<ServiceExecutor> startServices = this.createStartServices(entry.getValue(), operation, configuration);
            List<Future<Void>> futureList = this.runInParallel(startServices);
            for (Future<Void> future : futureList) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    cat.debug("Exception getting future ", e);
                }
                catch (ExecutionException e) {
                    cat.debug("Exception getting future ", e);
                }
            }
            cat.info("Finished services with priority ", entry.getKey());
        }
    }

    protected void saveForTests(Integer key, HashSet<ServiceExecutor> value) {
    }

    private List<Future<Void>> runInParallel(HashSet<ServiceExecutor> services) {
        try {
            return this.execService.invokeAll(services);
        }
        catch (InterruptedException e) {
            cat.error("Exception thrown starting services ", e);
            return new ArrayList<Future<Void>>();
        }
    }

    private HashSet<ServiceExecutor> createStartServices(HashSet<ServiceExecutor> services, ServiceExecutor.OperationType operationType, Configuration configuration) {
        HashSet<ServiceExecutor> resultSet = new HashSet<ServiceExecutor>();
        for (ServiceExecutor serviceExecutor : services) {
            resultSet.add(serviceExecutor.getOperation(operationType, configuration));
        }
        return resultSet;
    }
}

