/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.stream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class IsolatedXMLStreamReader
extends StreamReaderDelegate {
    private int level = 0;

    public IsolatedXMLStreamReader(XMLStreamReader reader) {
        super(reader);
    }

    @Override
    public int getEventType() {
        if (this.level == 0) {
            return 7;
        }
        return super.getEventType();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.level == 0 || this.level == -1) {
            return true;
        }
        if (this.level > 0) {
            return super.hasNext();
        }
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.level == 0) {
            ++this.level;
            int event = this.getEventType();
            if (1 == event) {
                return event;
            }
            throw new XMLStreamException("The initial iterator position must be at START_ELEMENT");
        }
        if (this.level == -1) {
            --this.level;
            return 8;
        }
        if (this.hasNext()) {
            int event = super.next();
            switch (event) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    --this.level;
                    if (this.level != 0) break;
                    this.level = -1;
                }
            }
            return event;
        }
        throw new XMLStreamException("There are no more events");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        --this.level;
        return super.getElementText();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.level == 0 && this.getParent().isStartElement()) {
            ++this.level;
            return 1;
        }
        int next = super.nextTag();
        if (next == 1) {
            ++this.level;
        } else if (next == 2) {
            --this.level;
        }
        return next;
    }
}

