/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxElement;
import com.cognos.pogo.stax.utils.StaxEntryLocalName;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxArrayNoLookup
extends StaxEntryLocalName {
    private static final List<StaxElement> EMPTY_LIST = Collections.emptyList();
    private List<StaxElement> array;

    protected abstract StaxElement createArrayEntry(XMLStreamReader var1, String var2) throws XMLStreamException;

    protected abstract StaxElement cloneArrayEntry(StaxElement var1);

    public StaxArrayNoLookup() {
        this.array = EMPTY_LIST;
    }

    public StaxArrayNoLookup(StaxArrayNoLookup source) {
        this.array = this.cloneList(source.array);
    }

    private List<StaxElement> cloneList(List<StaxElement> source) {
        if (source.isEmpty()) {
            return EMPTY_LIST;
        }
        ArrayList<StaxElement> clone = new ArrayList<StaxElement>(source.size());
        for (StaxElement entry : source) {
            clone.add(this.cloneArrayEntry(entry));
        }
        return clone;
    }

    @Override
    public boolean isPresent() {
        return this.array != EMPTY_LIST;
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.createArray(StaxArrayNoLookup.parseArraySize(xsr));
        if (this.parseFirstItem(xsr, entryName)) {
            super.parse(xsr, entryName);
        }
    }

    private boolean parseFirstItem(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        if (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            this.setEntryLocalName(xsr.getLocalName());
            this.parseElement(xsr, null);
            return true;
        }
        return false;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String ignore) throws XMLStreamException {
        this.array.add(this.createArrayEntry(xsr, this.getEntryLocalName()));
    }

    protected void createArray(int size) {
        this.array = new ArrayList<StaxElement>(size);
    }

    public void writeXML(XMLStreamWriter xsw, String type, boolean writeNamespace) throws XMLStreamException {
        String itemType = this.convertPluralToSingular(type);
        StaxArrayNoLookup.writeStartArrayElement(type, itemType, this.array.size(), writeNamespace, xsw);
        Iterator<StaxElement> iterator = this.array.iterator();
        while (iterator.hasNext()) {
            StaxArrayNoLookup.writeStartBusElement(this.getEntryLocalName(), itemType, false, xsw);
            StaxElement entry = iterator.next();
            entry.writeXML(xsw);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.flush();
    }
}

