/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxEntryLocalName;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxNameValuePairArray
extends StaxEntryLocalName {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final StaxNameValuePairArray NULL = new StaxNameValuePairArray();
    private Map<String, String> nameValuePairs;
    private final String entryName;

    public StaxNameValuePairArray(String entryName) {
        this.entryName = entryName;
        this.nameValuePairs = EMPTY_MAP;
    }

    public StaxNameValuePairArray(StaxNameValuePairArray source) {
        this.entryName = source.entryName;
        this.nameValuePairs = this.cloneVarsMap(source.nameValuePairs);
    }

    public StaxNameValuePairArray() {
        this((String)null);
    }

    public StaxNameValuePairArray(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.entryName = entryName;
        this.parse(xsr, entryName);
    }

    private Map<String, String> cloneVarsMap(Map<String, String> otherMap) {
        return otherMap.isEmpty() ? EMPTY_MAP : new LinkedHashMap<String, String>(otherMap);
    }

    private void createVarsMap(int size) {
        this.nameValuePairs = new LinkedHashMap<String, String>(size);
    }

    @Override
    public boolean canParse(String entryName) {
        return this.entryName.equals(entryName);
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.createVarsMap(StaxNameValuePairArray.parseArraySize(xsr));
        if (this.parseFirstItem(xsr, entryName)) {
            super.parse(xsr, entryName);
        }
    }

    private boolean parseFirstItem(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        if (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            String localName = xsr.getLocalName();
            this.setEntryLocalName(localName);
            this.parseElement(xsr, localName);
            return true;
        }
        return false;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        NameValuePair item = new NameValuePair();
        while (StaxUtils.moveToNextElementWithinParent(localName, xsr)) {
            this.parseEntry(xsr, xsr.getLocalName(), item);
        }
        this.put(item);
    }

    private void parseEntry(XMLStreamReader xsr, String localName, NameValuePair item) throws XMLStreamException {
        if ("name".equals(localName)) {
            item.name = xsr.getElementText();
        } else if ("value".equals(localName)) {
            item.value = xsr.getElementText();
        }
    }

    private void put(NameValuePair item) {
        if (item.name != null) {
            this.put(item.name, item.value);
        }
    }

    @Override
    public boolean isPresent() {
        return this.nameValuePairs != EMPTY_MAP;
    }

    public String get(String key) {
        return this.nameValuePairs.get(key);
    }

    public void put(String key, String value) {
        this.getReadWriteTransportVars().put(key, value);
    }

    private Map<String, String> getReadWriteTransportVars() {
        if (this.nameValuePairs == EMPTY_MAP) {
            this.createVarsMap(20);
        }
        return this.nameValuePairs;
    }

    public void clear() {
        this.getReadWriteTransportVars().clear();
    }

    public void remove(String key) {
        this.getReadWriteTransportVars().remove(key);
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        String itemType = this.convertPluralToSingular(this.entryName);
        StaxNameValuePairArray.writeStartArrayElement(this.entryName, itemType, this.size(), writeNamespace, xsw);
        if (!this.isEmpty()) {
            this.writeItems(xsw, itemType);
        }
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeItems(XMLStreamWriter xsw, String itemType) throws XMLStreamException {
        for (Map.Entry<String, String> entry : this.nameValuePairs.entrySet()) {
            this.writeItem(xsw, itemType, entry.getKey(), entry.getValue());
        }
    }

    private void writeItem(XMLStreamWriter xsw, String itemType, String name, String value) throws XMLStreamException {
        StaxNameValuePairArray.writeStartElement(this.getEntryLocalName(), "bus", itemType, xsw);
        StaxNameValuePairArray.writeStringElement("name", name, xsw);
        StaxNameValuePairArray.writeStringElement("value", value, xsw);
        xsw.writeEndElement();
    }

    public int size() {
        return this.nameValuePairs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nameValuePairs.isEmpty();
    }

    public Set<String> getNames() {
        return this.nameValuePairs.keySet();
    }

    private class NameValuePair {
        String name;
        String value;

        private NameValuePair() {
        }
    }
}

