/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxMapEntry;
import com.cognos.pogo.stax.utils.StaxVars;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class StaxVarsMap
extends StaxVars {
    private static final Map<String, StaxMapEntry> EMPTY_MAP = Collections.emptyMap();
    protected Map<String, StaxMapEntry> vars;

    public StaxVarsMap() {
        this.vars = EMPTY_MAP;
    }

    public StaxVarsMap(StaxVarsMap source) {
        this.vars = this.cloneVarsMap(source.vars);
    }

    public StaxVarsMap(int size) {
        this.vars = this.createVarsMap(size);
    }

    private Map<String, StaxMapEntry> cloneVarsMap(Map<String, StaxMapEntry> source) {
        if (source.isEmpty()) {
            return EMPTY_MAP;
        }
        Map<String, StaxMapEntry> clone = this.createVarsMap(source.size());
        for (Map.Entry<String, StaxMapEntry> entry : source.entrySet()) {
            clone.put(entry.getKey(), this.cloneMapEntry(entry.getValue()));
        }
        return clone;
    }

    private Map<String, StaxMapEntry> createVarsMap(int size) {
        return new LinkedHashMap<String, StaxMapEntry>(size);
    }

    @Override
    protected void createCollection(int size) {
        this.vars = this.createVarsMap(size);
    }

    @Override
    public boolean isPresent() {
        return this.vars != EMPTY_MAP;
    }

    @Override
    protected void saveEntry(StaxMapEntry entry) {
        this.vars.put(entry.getName(), entry);
    }

    public StaxMapEntry get(String key) {
        return this.vars.get(key);
    }

    public void put(String key, StaxMapEntry value) {
        if (this.vars == EMPTY_MAP) {
            this.vars = this.createVarsMap(10);
        }
        this.vars.put(key, value);
    }

    public void clear() {
        if (this.vars != EMPTY_MAP) {
            this.vars.clear();
        }
    }

    public void remove(String key) {
        if (this.vars != EMPTY_MAP) {
            this.vars.remove(key);
        }
    }

    @Override
    public int size() {
        return this.vars.size();
    }

    public Set<Map.Entry<String, StaxMapEntry>> getEntrySet() {
        return Collections.unmodifiableSet(this.vars.entrySet());
    }

    @Override
    public Collection<StaxMapEntry> getValues() {
        return Collections.unmodifiableCollection(this.vars.values());
    }
}

