/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils.recorder;

import com.cognos.pogo.stax.utils.recorder.Recorder;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class NamespaceRecorder
implements Recorder {
    private List<NamespaceSpec> namespaces = new LinkedList<NamespaceSpec>();
    private XMLStreamReader inputReader = null;

    public NamespaceRecorder(XMLStreamReader inInputReader) {
        this.inputReader = inInputReader;
    }

    @Override
    public void record() throws XMLStreamException {
        int namespaceCount = this.inputReader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = this.inputReader.getNamespacePrefix(i);
            String url = this.inputReader.getNamespaceURI(i);
            NamespaceSpec namespaceSpec = new NamespaceSpec(prefix, url);
            this.namespaces.add(namespaceSpec);
        }
    }

    @Override
    public void replay(XMLStreamWriter streamWriter) throws XMLStreamException {
        for (NamespaceSpec spec : this.namespaces) {
            streamWriter.writeNamespace(spec.getPrefix(), spec.getUrl());
        }
    }

    private class NamespaceSpec {
        private String prefix = null;
        private String url = null;

        public NamespaceSpec(String inPrefix, String inURL) {
            this.prefix = inPrefix;
            this.url = inURL;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

