/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils.recorder;

import com.cognos.pogo.stax.utils.recorder.AttributeRecorder;
import com.cognos.pogo.stax.utils.recorder.NamespaceRecorder;
import com.cognos.pogo.stax.utils.recorder.Recorder;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StartElementRecorder
implements Recorder {
    private XMLStreamReader inputReader = null;
    private LinkedList<AttributeRecorder> attributes = new LinkedList();
    private NamespaceRecorder namespaceRecorder = null;
    private String localName = null;
    private String namespaceURI = null;
    private String prefix = null;
    private String elementText = null;

    public StartElementRecorder(XMLStreamReader inInputReader) {
        this.inputReader = inInputReader;
        this.namespaceRecorder = new NamespaceRecorder(inInputReader);
    }

    @Override
    public void record() throws XMLStreamException {
        if (this.inputReader.isStartElement()) {
            this.localName = this.inputReader.getLocalName();
            this.namespaceURI = this.inputReader.getNamespaceURI();
            this.prefix = this.inputReader.getPrefix();
            if (this.inputReader.hasText()) {
                this.elementText = this.inputReader.getElementText();
            }
            this.namespaceRecorder.record();
            int attributeCount = this.inputReader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                AttributeRecorder attributeRecorder = new AttributeRecorder(this.inputReader, i);
                attributeRecorder.record();
                this.attributes.add(attributeRecorder);
            }
        }
    }

    @Override
    public void replay(XMLStreamWriter streamWriter) throws XMLStreamException {
        NamespaceContext namespaceContext = streamWriter.getNamespaceContext();
        String defaultNamespaceURI = namespaceContext.getNamespaceURI("");
        if (this.prefix == null && defaultNamespaceURI != null && defaultNamespaceURI.length() != 0 && defaultNamespaceURI.equalsIgnoreCase(this.namespaceURI)) {
            streamWriter.writeStartElement(this.localName);
        } else {
            streamWriter.writeStartElement(this.prefix, this.localName, this.namespaceURI);
        }
        if (this.elementText != null && this.elementText.length() != 0) {
            streamWriter.writeCharacters(this.elementText);
        }
        this.namespaceRecorder.replay(streamWriter);
        for (AttributeRecorder recorder : this.attributes) {
            recorder.replay(streamWriter);
        }
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public LinkedList<AttributeRecorder> getAttributes() {
        return this.attributes;
    }

    public String getElementText() {
        return this.elementText;
    }

    public void setElementText(String elementText) {
        this.elementText = elementText;
    }
}

