/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils.recorder;

import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.recorder.CDATARecorder;
import com.cognos.pogo.stax.utils.recorder.EndElementRecorder;
import com.cognos.pogo.stax.utils.recorder.NamespaceRecorder;
import com.cognos.pogo.stax.utils.recorder.Recorder;
import com.cognos.pogo.stax.utils.recorder.StartElementRecorder;
import com.cognos.pogo.stax.utils.recorder.TextRecorder;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxRecorder {
    LinkedList<Recorder> recorded = new LinkedList();
    private boolean stopRecording = false;
    private XMLStreamReader inputReader = null;

    public StaxRecorder(XMLStreamReader inInputReader) {
        this.inputReader = inInputReader;
    }

    public void recordTo(String stopElementName) throws XMLStreamException {
        this.recordElement(stopElementName);
        while (this.inputReader.hasNext() && !this.stopRecording) {
            this.inputReader.next();
            this.recordElement(stopElementName);
        }
    }

    public void reset() {
        this.stopRecording = false;
        this.recorded.clear();
    }

    public void recordAll() throws XMLStreamException {
        this.recordElement("");
        while (this.inputReader.hasNext()) {
            this.inputReader.next();
            this.recordElement("");
        }
    }

    private void recordElement(String stopElementName) throws XMLStreamException {
        int event = this.inputReader.getEventType();
        switch (event) {
            case 10: {
                break;
            }
            case 12: {
                CDATARecorder cDataRecorder = new CDATARecorder(this.inputReader);
                cDataRecorder.record();
                this.recorded.add(cDataRecorder);
                break;
            }
            case 4: {
                TextRecorder textRecorder = new TextRecorder(this.inputReader);
                textRecorder.record();
                this.recorded.add(textRecorder);
                break;
            }
            case 5: {
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                EndElementRecorder endRecorder = new EndElementRecorder(this.inputReader);
                endRecorder.record();
                if (stopElementName.equalsIgnoreCase(endRecorder.getLocalName())) {
                    this.stopRecording = true;
                    break;
                }
                this.recorded.add(endRecorder);
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                NamespaceRecorder recorder = new NamespaceRecorder(this.inputReader);
                recorder.record();
                this.recorded.add(recorder);
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                StartElementRecorder startRecorder = new StartElementRecorder(this.inputReader);
                startRecorder.record();
                this.recorded.add(startRecorder);
            }
        }
    }

    public void transferTo(XMLStreamWriter xsw, String startElementName, String stopElementName) throws XMLStreamException {
        boolean transfer = false;
        while (this.inputReader.hasNext()) {
            this.inputReader.next();
            int event = this.inputReader.getEventType();
            switch (event) {
                case 10: {
                    break;
                }
                case 12: {
                    CDATARecorder cDataRecorder = new CDATARecorder(this.inputReader);
                    cDataRecorder.record();
                    if (!transfer) break;
                    cDataRecorder.replay(xsw);
                    break;
                }
                case 4: {
                    TextRecorder textRecorder = new TextRecorder(this.inputReader);
                    textRecorder.record();
                    if (!transfer) break;
                    textRecorder.replay(xsw);
                    break;
                }
                case 5: {
                    break;
                }
                case 11: {
                    break;
                }
                case 8: {
                    break;
                }
                case 2: {
                    EndElementRecorder endRecorder = new EndElementRecorder(this.inputReader);
                    endRecorder.record();
                    if (transfer) {
                        endRecorder.replay(xsw);
                    }
                    if (!stopElementName.equalsIgnoreCase(endRecorder.getLocalName())) break;
                    return;
                }
                case 15: {
                    break;
                }
                case 9: {
                    break;
                }
                case 13: {
                    NamespaceRecorder recorder = new NamespaceRecorder(this.inputReader);
                    recorder.record();
                    if (!transfer) break;
                    recorder.replay(xsw);
                    break;
                }
                case 14: {
                    break;
                }
                case 3: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    StartElementRecorder startRecorder = new StartElementRecorder(this.inputReader);
                    startRecorder.record();
                    if (startRecorder.getLocalName().equalsIgnoreCase(startElementName)) {
                        transfer = true;
                    }
                    if (!transfer) break;
                    startRecorder.replay(xsw);
                }
            }
        }
    }

    public String getElementText(String elementName) {
        String elementText = null;
        String lastStartElementName = null;
        for (Recorder recorder : this.recorded) {
            if (recorder instanceof StartElementRecorder) {
                String elementLocalName;
                StartElementRecorder startElementRecorder = (StartElementRecorder)recorder;
                lastStartElementName = elementLocalName = startElementRecorder.getLocalName();
                if (elementLocalName.equalsIgnoreCase(elementName) && (elementText = startElementRecorder.getElementText()) != null && elementText.length() != 0) break;
            }
            if (!(recorder instanceof TextRecorder)) continue;
            TextRecorder textRecorder = (TextRecorder)recorder;
            if (!lastStartElementName.equalsIgnoreCase(elementName)) continue;
            elementText = textRecorder.getElementText();
            break;
        }
        return elementText;
    }

    public String getFirstChildName(String parentName) {
        boolean foundParent = false;
        String childName = null;
        for (Recorder recorder : this.recorded) {
            EndElementRecorder endElementRecorder;
            if (recorder instanceof StartElementRecorder) {
                StartElementRecorder startElementRecorder = (StartElementRecorder)recorder;
                if (foundParent) {
                    childName = startElementRecorder.getLocalName();
                    break;
                }
                if (startElementRecorder.getLocalName().equalsIgnoreCase(parentName)) {
                    foundParent = true;
                }
            }
            if (!(recorder instanceof EndElementRecorder) || !(endElementRecorder = (EndElementRecorder)recorder).getLocalName().equalsIgnoreCase(parentName)) continue;
            break;
        }
        return childName;
    }

    public String getRootElementName() {
        String rootElementName = null;
        for (Recorder recorder : this.recorded) {
            if (!(recorder instanceof StartElementRecorder)) continue;
            StartElementRecorder startElementRecorder = (StartElementRecorder)recorder;
            rootElementName = startElementRecorder.getLocalName();
            break;
        }
        return rootElementName;
    }

    public void close() throws XMLStreamException {
        this.inputReader.close();
    }

    public void replay(XMLStreamWriter streamWriter) throws XMLStreamException {
        for (Recorder recorder : this.recorded) {
            recorder.replay(streamWriter);
        }
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.recorded != null && this.recorded.size() != 0) {
            empty = false;
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asXML() throws XMLStreamException {
        XMLStreamWriter streamWriter = null;
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            streamWriter = XMLStreamFactory.createXMLStreamWriter(stringWriter);
            this.replay(streamWriter);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            if (streamWriter != null) {
                streamWriter.flush();
                streamWriter.close();
            }
        }
    }
}

