/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class HopCountChecker {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private int maxHopCount = 0;

    public HopCountChecker(ServletConfig config) {
        String xmaxHopCounts = config.getInitParameter("maxHopCount");
        try {
            if (xmaxHopCounts != null && !"".equalsIgnoreCase(xmaxHopCounts)) {
                this.maxHopCount = Integer.parseInt(xmaxHopCounts);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void checkHopCount(long hopCount, BIBusEnvelope request_env) throws ServletException {
        if (this.maxHopCount > 0 && hopCount > (long)this.maxHopCount) {
            String errorMsg = DispatcherStrings.getInstance().getString("MAXIMUM_HOP_COUNT") + String.valueOf(this.maxHopCount);
            PogoException pogoException = new PogoException(errorMsg);
            String sessionID = "NA";
            String requestID = "NA";
            if (request_env.getBiBusHeader().getTracking() != null) {
                if (request_env.getBiBusHeader().getTracking().getSessionContext() != null) {
                    sessionID = request_env.getBiBusHeader().getTracking().getSessionContext();
                }
                if (request_env.getBiBusHeader().getTracking().getRequestContext() != null) {
                    requestID = request_env.getBiBusHeader().getTracking().getRequestContext();
                }
            }
            cat.error(errorMsg + ", SessionID[" + sessionID + "], RequestID[" + requestID + "]", pogoException);
            throw new ServletException((Throwable)pogoException);
        }
    }
}

