/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.auth.CookieDecoder;
import com.cognos.pogo.impl.PogoHttpServletRequestWrapper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.transport.SOAPRequestProcessor;
import java.io.InputStream;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequestProcessor
extends SOAPRequestProcessor {
    protected MultipartRequestProcessor(String[][] extraHeaders) {
        super(extraHeaders);
    }

    @Override
    public SOAPEnvelope createRequestEnvelope(HttpServletRequest request, MessageContext mc) throws Exception {
        if (this.isLocal(request)) {
            PogoHttpServletRequestWrapper wrapper = (PogoHttpServletRequestWrapper)request;
            wrapper.useLocalRequestStream();
        }
        Iterator<?> it = this.getMIMEPartIterator(request, mc);
        InputStream isPart = (InputStream)it.next();
        InternetHeaders headers = new InternetHeaders(isPart);
        mc.setProperty("request.headers", headers);
        BIBusEnvelope request_env = this.createEnvelope(mc, isPart);
        request_env.setDispatcherTransport("html", "false");
        if (this.isGatewayRequest(request)) {
            mc.setProperty("checkCapabilities", Boolean.TRUE);
        }
        Cookie[] cookies = CookieDecoder.getCookies(request);
        this.copyHttpCookiesToBIBusCookieVars(cookies, request_env);
        this.copyRoutingHeaderToEnvelope(request_env, request);
        mc.setProperty("SCRIPT_NAME", this.createScriptPath(request));
        mc.setProperty("HTTP_HOST", request.getHeader("host"));
        this.setWebContentRoot(request, request_env);
        return request_env;
    }
}

