/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.handlers.xts.PowerPlayDrillThruHandler;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ParamBucket {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private Map<String, Vector<String>> params = new HashMap<String, Vector<String>>();
    private int maxParams;

    public ParamBucket() {
        String maxParamsString = PropertyInserter.getProperty("dispatcher.MaxRequestParameters", String.valueOf(1024));
        try {
            this.maxParams = Integer.parseInt(maxParamsString);
        }
        catch (NumberFormatException ex) {
            this.maxParams = 1024;
            cat.warn("Invalid property value [", "dispatcher.MaxRequestParameters", "] = [", maxParamsString + "]. Using default value: ", this.maxParams);
        }
        cat.debug("Using dispatcher.MaxRequestParameters: " + this.maxParams);
    }

    public Iterator<String> getNames() {
        return this.params.keySet().iterator();
    }

    public Vector<String> getValues(String name) {
        return this.params.get(name);
    }

    public String getValue(String name) {
        Vector<String> v = this.params.get(name);
        if (v == null || v.isEmpty()) {
            return null;
        }
        return v.lastElement();
    }

    public void add(String name, String value) {
        if (this.params.size() >= this.maxParams) {
            throw new IllegalStateException("Parameter count has exceeded the maximum allowed: " + this.maxParams);
        }
        Vector<String> v = this.params.get(name);
        if (v == null) {
            v = new Vector();
            this.params.put(name, v);
        }
        v.add(value);
    }

    public boolean remove(String name, String value) {
        Vector<String> v = this.params.get(name);
        if (v == null) {
            return false;
        }
        return v.remove(value);
    }

    protected void replace(String name, String newValue) {
        Vector<String> v = this.params.get(name);
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == null) continue;
            v.set(i, newValue);
        }
    }

    public void parse(String sq) throws UnsupportedEncodingException {
        int iamp = 0;
        String encoding = "UTF-8";
        String drillThruReqEncoding = PowerPlayDrillThruHandler.determineEncoding(sq);
        if (drillThruReqEncoding != null) {
            encoding = drillThruReqEncoding;
        }
        boolean encodingSpecified = false;
        while (sq.length() > 0) {
            String snvp;
            iamp = sq.indexOf(38);
            if (iamp == 0) {
                sq = sq.substring(1);
                continue;
            }
            if (iamp != -1) {
                snvp = sq.substring(0, iamp);
                sq = sq.substring(iamp + 1);
            } else {
                snvp = sq;
                sq = "";
            }
            int ieq = snvp.indexOf(61);
            if (ieq == -1) {
                this.add(snvp, "");
                continue;
            }
            String name = snvp.substring(0, ieq);
            String rawval = snvp.substring(ieq + 1);
            cat.debug("raw param: ", name, " = \"", rawval, "\"");
            try {
                name = URLEncoderDecoder.decode(name, encoding);
                String val = URLEncoderDecoder.decode(rawval, encoding);
                if ("encoding".equals(name)) {
                    encodingSpecified = true;
                    if (!encoding.equals("UTF-8")) {
                        cat.debug("Force value of encoding= to UTF-8 to avoid decoding again if request is roundtripped and resubmitted, as in a logon.");
                        val = "UTF-8";
                    }
                }
                cat.debug("decoded param: ", name, " = \"", val, "\"");
                this.add(name, val);
            }
            catch (UnsupportedEncodingException uee) {
                throw uee;
            }
            catch (Exception x) {
                cat.debug("problem processing request parameters", x);
            }
        }
        if (!encodingSpecified) {
            cat.debug("add encoding=UTF-8 to avoid re-encoding if the request is round-tripped.");
            this.add("encoding", "UTF-8");
        }
    }

    public int getMaxParams() {
        return this.maxParams;
    }
}

