/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.pogo.bibus.Crypto;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import com.cognos.pogo.util.base64;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.dom4j.Element;

public class CAMUtils {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final int CAM_SUCCESS = 1;
    private static CAMFactory camFactory;
    private static Crypto crypto;
    private UserSessionIDSession userSessionIDSession;
    private SigningSession signingSession;

    public static void setCryptoFacilityForTesting(Crypto crypto) {
        CAMUtils.crypto = crypto;
    }

    public CAMFactory getCamFactory() throws CAMCryptoException {
        if (camFactory == null) {
            camFactory = crypto.getCamFactory();
        }
        return camFactory;
    }

    public void initialize() {
        try {
            this.userSessionIDSession = crypto.createUserSessionIDSession();
            this.signingSession = this.getCamFactory().createSigningSession();
        }
        catch (CAMCryptoException ex) {
            cat.error("Failed to initialize CAMUtils", ex);
        }
    }

    public boolean checkValidCAMUserSessionID(String base64UserSessionID) throws Exception {
        try {
            int camCode = this.userSessionIDSession.verifyUserSessionID(base64UserSessionID.getBytes());
            if (camCode == 1) {
                return true;
            }
            cat.error("CAM VerifyUserSessionID failed");
            return false;
        }
        catch (CAMCryptoException ex) {
            cat.error("VerifyUserSessionID failed", ex);
            throw ex;
        }
        catch (Exception ex) {
            cat.error("NULL UserSessionIDSession", ex);
            throw ex;
        }
    }

    public boolean verifyCryptoHMAC(byte[] hmacObj, String clearText) throws CAMCryptoException {
        return this.signingSession.hmacVerify(hmacObj, clearText.getBytes());
    }

    public InputStream createCipherInputStream(String fileId) throws IOException {
        try {
            return this.getCamFactory().createCipherInputStream(fileId);
        }
        catch (CAMCryptoException ex) {
            cat.error("CAMCryptoException exception while calling CAMFactory.createCipherInputStream", ex);
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    public byte[] encryptData(CAMFactory camFactory, byte[] bytes) throws CAMCryptoException {
        EncryptingSession encryptSession = camFactory.createEncryptingSession();
        return encryptSession.encryptData(bytes);
    }

    @Deprecated
    public boolean verifyTrustToken(byte[] token, byte[] xml) throws CAMCryptoException {
        return this.verifyTrustToken(token, xml, null);
    }

    public boolean verifyTrustToken(byte[] token, byte[] xml, String passportID) throws CAMCryptoException {
        GenericTrustedSession genericTrustedSession = this.getCamFactory().createGenericTrustedSession();
        return genericTrustedSession.verifyTrustToken(token, xml, passportID);
    }

    public byte[] signRequest(byte[] requestBytes, String serviceID) throws Exception {
        return crypto.signTrustedRequest(requestBytes, serviceID);
    }

    void resetCamFactoryForTesting() {
        camFactory = null;
    }

    public HttpClient createHttpClient(URL url) throws CAMCryptoException {
        return this.getCamFactory().createHttpClient(url);
    }

    public static CAMCookie createCookie(String passportID) {
        CAMCookie camCookie = CAMCookieFactory.createCAMCookie((String)passportID);
        CAMUtils.logCamCookie(camCookie, passportID);
        return camCookie;
    }

    private static void logCamCookie(CAMCookie camCookie, String passportID) {
        if (cat.isDebugEnabled()) {
            cat.debug("CAMCookie created from passportId:");
            cat.debug("   passportId: ", passportID);
            cat.debug("   camElement: ", CAMUtils.getCamCookieAsXml(camCookie));
        }
    }

    private static String getCamCookieAsXml(CAMCookie camCookie) {
        try {
            Element camElement = camCookie != null ? camCookie.asXML() : null;
            String asXML = camElement != null ? camElement.asXML() : null;
            return XmlUtils.prettyPrint(asXML);
        }
        catch (Exception e) {
            return "Exception caught while reading CAM cookie: " + e.getMessage();
        }
    }

    public String decrypt(String encrypted) throws CAMCryptoException {
        cat.debug("Decrypting: ", encrypted);
        byte[] encryptedBytes = base64.decode(0, encrypted);
        byte[] decryptedBytes = crypto.decryptData(encryptedBytes);
        return new String(decryptedBytes);
    }

    static {
        crypto = new CryptoFacility();
    }
}

