/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.transport.PogoServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ContentTypeFileExtensions {
    private static final String propertiesFile = "contenttype_extensions.properties";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoServlet.class.getName());
    private Properties contentTypeExts = new Properties();

    public ContentTypeFileExtensions() {
        this.loadContentTypeExtensionsList(ContentTypeFileExtensions.getDefaultFileExtensionsMap());
    }

    public ContentTypeFileExtensions(Properties contentTypeExts) {
        if (contentTypeExts != null) {
            this.contentTypeExts = (Properties)contentTypeExts.clone();
        }
    }

    public String getFileExtension(String contentType) {
        return (String)this.contentTypeExts.get(contentType);
    }

    private static InputStream getDefaultFileExtensionsMap() {
        cat.info("loading contentTypeFileExtensions from: contenttype_extensions.properties");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(propertiesFile);
    }

    private void loadContentTypeExtensionsList(InputStream is) {
        try {
            if (is == null) {
                cat.error("can't find resource contenttype_extensions.properties");
                return;
            }
            this.contentTypeExts.load(is);
        }
        catch (IOException e) {
            cat.error("failed to load contenttype_extensions.properties");
        }
    }
}

