/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Duration {
    static final String classname = Duration.class.getName();
    static final Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(classname);
    long millis;
    private static final String DAY_STRING = "([0-9]+D)?";
    private static final String HOUR_STRING = "([0-9]+H)?";
    private static final String MINUTE_STRING = "([0-9]+M)?";
    private static final String SECOND_STRING = "([0-9]+S)?";
    static final long SECONDS_FACTOR = 1000L;
    static final long MINUTES_FACTOR = 60000L;
    static final long HOURS_FACTOR = 3600000L;
    static final long DAYS_FACTOR = 86400000L;
    private static final Pattern DURATION_PATTERN = Pattern.compile("P([0-9]+D)?T([0-9]+H)?([0-9]+M)?([0-9]+S)?");

    public Duration() {
        this.millis = 0L;
    }

    public Duration(long millis) {
        this.millis = millis;
    }

    public long getMilliseconds() {
        return this.millis;
    }

    public static Duration valueOf(String durationStr) {
        Matcher matcher = DURATION_PATTERN.matcher(durationStr);
        if (matcher.matches()) {
            String timeStr;
            Duration thisDuration = new Duration();
            int pIdx = durationStr.indexOf(80);
            int tIdx = durationStr.indexOf(84);
            int dIdx = durationStr.indexOf(68);
            if (dIdx > 0) {
                thisDuration.addMills(Duration.daysToMills(Integer.parseInt(durationStr.substring(pIdx + 1, dIdx))));
            }
            if (tIdx > 0 && (timeStr = durationStr.substring(tIdx + 1)) != null && timeStr.length() > 0) {
                int hIdx = timeStr.indexOf(72);
                int mIdx = timeStr.indexOf(77);
                int sIdx = timeStr.indexOf(83);
                if (hIdx > 0) {
                    thisDuration.addMills(Duration.hourToMills(Integer.parseInt(timeStr.substring(0, hIdx))));
                }
                if (mIdx > 0) {
                    thisDuration.addMills(Duration.minutesToMills(Integer.parseInt(timeStr.substring(hIdx + 1, mIdx))));
                }
                if (sIdx > 0) {
                    if (mIdx > 0) {
                        thisDuration.addMills(Duration.secondsToMills(Integer.parseInt(timeStr.substring(mIdx + 1, sIdx))));
                    } else {
                        thisDuration.addMills(Duration.secondsToMills(Integer.parseInt(timeStr.substring(hIdx + 1, sIdx))));
                    }
                }
            }
            return thisDuration;
        }
        throw new IllegalArgumentException("String value [" + durationStr + "] is not in the expected format.");
    }

    private long addMills(long value) {
        this.millis += value;
        return this.millis;
    }

    public static long daysToMills(int value) {
        return 86400000L * (long)value;
    }

    public static long hourToMills(int value) {
        return 3600000L * (long)value;
    }

    public static long minutesToMills(int value) {
        return 60000L * (long)value;
    }

    public static long secondsToMills(int value) {
        return 1000L * (long)value;
    }
}

