/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.impl.DispatcherStrings;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LengthLimitedInputStream
extends FilterInputStream {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(LengthLimitedInputStream.class.getName());
    private int avail;

    public LengthLimitedInputStream(InputStream is, int length) {
        super(is);
        this.avail = length;
    }

    @Override
    public int available() {
        return this.avail;
    }

    @Override
    public int read() throws IOException {
        if (this.avail == 0) {
            return -1;
        }
        int iread = super.read();
        if (iread == -1 && this.avail > 0) {
            this.avail = 0;
            throw new IOException(DispatcherStrings.getInstance().getString("LengthLimitedInputStream.unexpectedEOS"));
        }
        --this.avail;
        return iread;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int iread;
        if (this.avail == 0) {
            return -1;
        }
        if (this.avail < len) {
            len = this.avail;
        }
        if ((iread = super.read(b, off, len)) == -1) {
            this.avail = 0;
            throw new IOException(DispatcherStrings.getInstance().getString("LengthLimitedInputStream.unexpectedEOS"));
        }
        this.avail -= iread;
        return iread;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

