/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PerfTimer;

public class PerfLogger
implements Cloneable {
    protected LogTypedLogger perfLogger = null;
    protected String className;
    protected static final String COMPONENT = "dispatcher";
    protected String requestId = null;
    protected String sessionId = null;

    public PerfLogger(String loggerName, Class<?> classObj, MessageContext mc) {
        this(loggerName, classObj);
        BIBusEnvelope env;
        if (this.isEnabled() && mc != null && (env = (BIBusEnvelope)mc.getProperty("request.envelope")) != null) {
            this.requestId = env.getRequestContext();
            this.sessionId = env.getSessionContext();
        }
    }

    public PerfLogger(String loggerName, Class<?> classObj) {
        this.perfLogger = LogTypedLogger.getInstance((String)loggerName, LogPerfIndication.class);
        this.className = classObj.getName();
    }

    public PerfLogger cloneIfEnabled(Class<?> classObj) {
        return this.isEnabled() ? this.cloneForClass(classObj) : this;
    }

    private PerfLogger cloneForClass(Class<?> classObj) {
        try {
            PerfLogger newCopy = (PerfLogger)this.clone();
            newCopy.className = classObj != null ? classObj.getName() : null;
            return newCopy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEnabled() {
        return this.perfLogger != null && this.perfLogger.isEnabled(50000);
    }

    public boolean isPerfLevelEnabled(Level level) {
        return this.perfLogger != null && this.perfLogger.isEnabled(level.getLevel());
    }

    public PerfTimer startTimer(Level level, String method, Object ... description) {
        if (!this.isPerfLevelEnabled(level)) {
            return null;
        }
        CCLResourceCounterSet counter = new CCLResourceCounterSet("Execution", null);
        LogPerfIndication indication = this.createIndication(level, method, counter, description);
        this.writeToPerfLogger(indication);
        this.startCounter(counter);
        return new PerfTimer(indication);
    }

    private void startCounter(CCLResourceCounterSet counter) {
        counter.enableResourceCounter();
    }

    private void writeToPerfLogger(LogPerfIndication indication) {
        this.perfLogger.log((Object)indication);
    }

    private LogPerfIndication createIndication(Level level, String method, CCLResourceCounterSet counter, Object ... description) {
        LogPerfIndication indication = new LogPerfIndication(COMPONENT, 0, counter);
        indication.setLevel(level.getLevel());
        indication.setClassId(this.className != null ? this.className : COMPONENT);
        indication.setMethodId(method);
        indication.setLogData(this.getString(description));
        indication.setStatus("START");
        indication.setTime(System.currentTimeMillis());
        indication.setRequestID(this.requestId != null ? this.requestId : "");
        indication.setSessionID(this.sessionId != null ? this.sessionId : "");
        return indication;
    }

    public void stopTimer(PerfTimer timer) {
        if (this.perfLogger != null && timer != null) {
            LogPerfIndication indication = timer.getIndication();
            this.stopCounter(indication);
            indication.setStatus("FINISH");
            indication.setTime(System.currentTimeMillis());
            this.writeToPerfLogger(indication);
        }
    }

    private void stopCounter(LogPerfIndication timer) {
        timer.getCCLRCS().disableResourceCounter();
    }

    private String getString(Object[] args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }

    public static enum Level {
        LEVEL1(50000),
        LEVEL2(40000),
        LEVEL3(30000),
        LEVEL4(20000),
        LEVEL5(10000);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

